/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.Window;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.presenter.CreateAccountResourceRequest;
import com.clustercontrol.cloud.presenter.CreateCloudUserRequest;
import com.clustercontrol.cloud.presenter.IAccountResourceManager;
import com.clustercontrol.cloud.ui.dialogs.CreateAccountResourceDialog;
import com.clustercontrol.util.Messages;

public class CreateAccountResourceAction extends AbstractViewAction {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.CreateAccountResourceAction";

	private MessageManager messages = MessageManager.getInstance("messages");
	
	private String msgCreateAccountResourceConfirm = messages.getString("message.confirm_some_action_to_something", new Object[]{"word.account_resource", "word.create"});
	private String msgCreateAccountResourceResult = messages.getString("message.result_some_action_to_something", new Object[]{"word.account_resource", "word.create"});

	@Override
	protected void invoke(IAction action) throws InvocationException {
		
		CreateAccountResourceDialog dialog = new CreateAccountResourceDialog(this.viewPart.getSite().getShell());

		if (dialog.open() == Window.OK) {
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				msgCreateAccountResourceConfirm)) {
				
				CreateAccountResourceDialog.DialogOutput output = dialog.getOutput();
				
				IAccountResourceManager manager = Activator.getDefault().getCloudResourceManager().getAccountResourceManager();
				
				CreateAccountResourceRequest createAccountResourceRequest = new CreateAccountResourceRequest();
				ControlUtil.importObject(createAccountResourceRequest, output);
				CreateCloudUserRequest createCloudUserRequest = new CreateCloudUserRequest();
				ControlUtil.importObject(createCloudUserRequest, output);
				createCloudUserRequest.setDescription(output.getCloudUserDescription());
				createAccountResourceRequest.setDescription(output.getAccountResourceDescription());

				manager.createAccountResource(createAccountResourceRequest, createCloudUserRequest);
				
				com.clustercontrol.action.FacilityTree.refresh();

				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					msgCreateAccountResourceResult);
			}
			else {
				return;
			}
		}
	}
}