/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.presenter;



/**
 * イベントの基底クラス。
 * 
 * @author torun
 *
 * @param <S>
 * @param <L>
 */
public abstract class Event <S, L extends EventListener> {
	private S source;
	public Event(S source) {
		this.source = source;
	}
	/**
	 * イベントの発行者を取得。
	 * 
	 * @return
	 */
	public S getSource() {
		return source;
	}
	public abstract void dispatch(L listener);
	public abstract Type<L> getAssociatedType();
}