/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.commons.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.clustercontrol.cloud.Activator;

public class ParameterManager {
	private static final Map<String, ParameterManager> instances = new HashMap<String, ParameterManager>();
	
	private List<String> internalList;
	private Map<String, String> internalMap;
	private Map<String, String> reverseMap;

	private ParameterManager(String parameterName) {
		internalList = getInternalList(parameterName);
	}

	public static ParameterManager getInstance(String parameterName){
		ParameterManager pm = null;
		synchronized(instances){
			if(instances.containsKey(parameterName)){
				pm = instances.get(parameterName);
			} else {
				pm = new ParameterManager(parameterName);
				instances.put(parameterName, pm);
			}
		}
		return pm;
	}


	public static Object getOnlyValue(String key) {
		ParameterManager manager = getInstance(key);
		return manager.getList().get(0);
	}
	
	public String getValue(String key){
		return getMap().get(key);
	}
	
	public List<String> getList(){
		return new ArrayList<String>(internalList);
	}

	public Map<String, String> getMap(){
		if(internalMap == null){
			internalMap = new LinkedHashMap<String, String>();
			for(String tempStr: internalList){
				String key;
				String value;
				if(tempStr.indexOf(CloudClientConstants.PARAMETER_CONSTANTS_PARAMETER_DELIMITER) != -1){
					int delimiterIndex = tempStr.indexOf(CloudClientConstants.PARAMETER_CONSTANTS_PARAMETER_DELIMITER);
					key = tempStr.substring(0, delimiterIndex);
					if(tempStr.indexOf(CloudClientConstants.PARAMETER_CONSTANTS_PARAMETER_DELIMITER) != tempStr.length() - 1){
						value = tempStr.substring(delimiterIndex + 1);
					} else {
						value = "";
					}
				} else {
					key = tempStr;
					value = "";
				}
				internalMap.put(key, value);
			}
		}
		return new LinkedHashMap<String, String>(internalMap);
	}

	public Map<String, String> getReverseMap(){
		if(reverseMap == null){
			reverseMap = new LinkedHashMap<String, String>();
			for(Map.Entry<String, String> entry: getMap().entrySet()){
				reverseMap.put(entry.getValue(), entry.getKey());
			}
		}
		return new LinkedHashMap<String, String>(reverseMap);
	}
	
	private List<String> getInternalList(String parameterName){
		BufferedReader buffer = null;
        try{
        	FileReader file = new FileReader(Activator.getPluginPath() + "\\resources\\" + CloudClientConstants.PARAMETER_CONSTANTS_PARAMETER_FILENAME);
            buffer = new BufferedReader(file);
            String tempString;
            Boolean readOn = false;
            Boolean inCommentOut = false;
            Pattern pattern = Pattern.compile("\\{.*\\}");
            Pattern commentOut = Pattern.compile("[ \\t]*//");
            Pattern commnetOutStart = Pattern.compile("[ \\t]*/\\*");
            Pattern commnetOutEnd = Pattern.compile("\\*/[ \\t]*");
            Matcher matcher;
            List<String> list = new ArrayList<String>();                        
            while((tempString = buffer.readLine())!=null){
            	if(!inCommentOut){
            		matcher = commnetOutStart.matcher(tempString);
            		if(matcher.find()){
            			int start = matcher.start();
                		matcher = commnetOutEnd.matcher(tempString);
                		if(matcher.find()){
            				tempString = tempString.substring(0, start) + tempString.substring(matcher.end());
                		} else {
	        				tempString = tempString.substring(0, start);
	        				inCommentOut = true;
                		}
            		}
            	} else {
            		matcher = commnetOutEnd.matcher(tempString);
            		if(matcher.find()){
        				tempString = tempString.substring(matcher.end());
        				inCommentOut = false;
            		} else {
            			continue;
            		}
            	}
            	matcher = commentOut.matcher(tempString);
    			if(matcher.find()){
    				tempString = tempString.substring(0, matcher.start());
    			}
            	if(readOn){
                	matcher = pattern.matcher(tempString);
            		if(matcher.find()) break;
            		if(!tempString.equals("")){
            			list.add(tempString);
            		}
            	} else {
            		if(tempString.equals("{" + parameterName + "}")){
            			readOn = true;
            		}
            	}
            }
            if(list.isEmpty()){
            	throw new Exception("Parameter " + parameterName + " can't read in the parameter file.");
            }
            return list;
        }catch(Exception e){
            throw new IllegalStateException(e);
        }
        finally {
        	if (buffer != null) {
        		try {
					buffer.close();
				} catch (IOException e) {
				}
        	}
        }
	}
}
