/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views.actions;

import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.presenter.EditBillingDetailCollectorSettingRequet;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.ui.dialogs.BillingDetailCollectSettingDialog;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Text;

public class EditBillingDetailCollectionSettingAction
extends SingleSelectionActionEx {
    public static final String ID = "com.clustercontrol.cloud.ui.views.actions.EditBillingDetailCollectionSettingAction";
    private MessageManager messages = MessageManager.getInstance("messages");
    private String msgEditBillingDetailCollectionSettingsConfirm = this.messages.getString("message.confirm_some_action_to_something", new Object[]{"caption.billing_detail_collection_settings", "word.modify"});
    private String msgEditBillingDetailCollectionSettingsResult = this.messages.getString("message.result_some_action_to_something", new Object[]{"caption.billing_detail_collection_settings", "word.modify"});

    @Override
    protected void invoke(IAction action) throws InvocationException {
        IStructuredSelection selection = (IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection();
        final IAccountResource accountResource = (IAccountResource)selection.getFirstElement();
        BillingDetailCollectSettingDialog dialog = new BillingDetailCollectSettingDialog(this.viewPart.getSite().getShell());
        dialog.setBehavior(new BillingDetailCollectSettingDialog.IDialogBehavior(){

            @Override
            public void setupRetentionPeriod(Text txtRetentionPeriod) {
                if (accountResource.getRetentionPeriod() != null) {
                    txtRetentionPeriod.setText(accountResource.getRetentionPeriod().toString());
                }
            }

            @Override
            public void setupBillingDetailCollectorFlg(Button btnBillingDetailCollectorFlg) {
                if (accountResource.getBillingDetailCollectorFlg() != null) {
                    btnBillingDetailCollectorFlg.setSelection(accountResource.getBillingDetailCollectorFlg().booleanValue());
                }
            }
        });
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.msgEditBillingDetailCollectionSettingsConfirm)) {
                BillingDetailCollectSettingDialog.DialogOutput output = dialog.getOutput();
                EditBillingDetailCollectorSettingRequet request = new EditBillingDetailCollectorSettingRequet();
                ControlUtil.importObject(request, output);
                request.setAccountResourceId(accountResource.getAccountResourceId());
                accountResource.editBillingDetailCollectorSetting(request);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.msgEditBillingDetailCollectionSettingsResult);
            } else {
                return;
            }
        }
    }
}

