/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.TableViewerSorter;
import com.clustercontrol.cloud.presenter.AllPropertyObserver;
import com.clustercontrol.cloud.presenter.CollectionObserver2;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.ICloudTemplate;
import com.clustercontrol.cloud.presenter.ICloudTemplateManager;
import com.clustercontrol.cloud.presenter.IElement;
import com.clustercontrol.cloud.presenter.IFacility;
import com.clustercontrol.cloud.ui.views.AbstractCloudViewPart;
import com.clustercontrol.cloud.ui.views.IAROrientedView;
import com.clustercontrol.cloud.ui.views.ScopeView;
import com.clustercontrol.util.LoginManager;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class TemplatesView
extends AbstractCloudViewPart
implements ISelectionListener,
IAROrientedView {
    public static final String Id = "com.clustercontrol.cloud.ui.views.TemplatesView";
    private static MessageManager bundle_messages = MessageManager.getInstance("messages");
    private Table table;
    private TableViewer tableViewer;
    private Label lblHeader;
    private Label lblFooter;
    private ICloudTemplateManager cloudTemplateManager;
    private List<ICloudTemplate> cloudTemplates;
    private IAccountResource accountResource;
    private String headerTitle = bundle_messages.getString("word.account_resource_id") + bundle_messages.getString("caption.title_separator");
    private String footerTitle = bundle_messages.getString("word.view_item_count") + bundle_messages.getString("caption.title_separator");
    private IAccountResource.IRegion region;
    private CollectionObserver2<ICloudTemplate> elementObserver = new CollectionObserver2<ICloudTemplate>(){

        @Override
        public void elementAdded(CollectionObserver2.ElementAddedEvent<ICloudTemplate> event) {
            event.getAddedElement().addPropertyObserver2(IElement.allProperty, TemplatesView.this.propertyObserver);
            TemplatesView.this.cloudTemplates.add(event.getAddedElement());
            TemplatesView.this.internalSetInput();
            TemplatesView.this.lblFooter.setText(TemplatesView.this.footerTitle + TemplatesView.this.cloudTemplates.size());
            TemplatesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TemplatesView.this.tableViewer.refresh(true);
                    ISelection selection = TemplatesView.this.tableViewer.getSelection();
                    TemplatesView.this.getSite().getSelectionProvider().setSelection(selection);
                }
            });
        }

        @Override
        public void elementRemoved(CollectionObserver2.ElementRemovedEvent<ICloudTemplate> event) {
            event.getRemovedElement().removePropertyObserver2(IElement.allProperty, TemplatesView.this.propertyObserver);
            TemplatesView.this.cloudTemplates.remove(event.getRemovedElement());
            TemplatesView.this.internalSetInput();
            TemplatesView.this.lblFooter.setText(TemplatesView.this.footerTitle + TemplatesView.this.cloudTemplates.size());
            TemplatesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TemplatesView.this.tableViewer.refresh(true);
                    ISelection selection = TemplatesView.this.tableViewer.getSelection();
                    TemplatesView.this.getSite().getSelectionProvider().setSelection(selection);
                }
            });
        }
    };
    private AllPropertyObserver propertyObserver = new AllPropertyObserver(){

        @Override
        public void propertyChanged(AllPropertyObserver.ValueChangedEvent event) {
            TemplatesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TemplatesView.this.tableViewer.refresh(true);
                    ISelection selection = TemplatesView.this.tableViewer.getSelection();
                    TemplatesView.this.getSite().getSelectionProvider().setSelection(selection);
                }
            });
        }

        @Override
        public void elementRemoved(AllPropertyObserver.ElementRemovedEvent event) {
            TemplatesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TemplatesView.this.tableViewer.refresh(true);
                    ISelection selection = TemplatesView.this.tableViewer.getSelection();
                    TemplatesView.this.getSite().getSelectionProvider().setSelection(selection);
                }
            });
        }

        @Override
        public void elementAdded(AllPropertyObserver.ElementAddedEvent event) {
            TemplatesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TemplatesView.this.tableViewer.refresh(true);
                    ISelection selection = TemplatesView.this.tableViewer.getSelection();
                    TemplatesView.this.getSite().getSelectionProvider().setSelection(selection);
                }
            });
        }
    };

    public TemplatesView() {
        LoginManager.login();
    }

    @Override
    protected void internalCreatePartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.lblHeader = new Label(composite, 0);
        this.lblHeader.setSize(this.lblHeader.getSize().x, 80);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.lblHeader.setLayoutData((Object)gridData);
        Composite composite_1 = new Composite(composite, 0);
        TableColumnLayout tcl_composite_1 = new TableColumnLayout();
        composite_1.setLayout((Layout)tcl_composite_1);
        this.tableViewer = new TableViewer(composite_1, 67586);
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        for (final ViewColumn column : ViewColumn.values()) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
            TableColumn tableColumn = tableViewerColumn.getColumn();
            tcl_composite_1.setColumnData((Widget)tableColumn, (ColumnLayoutData)column.getPixelData());
            tableColumn.setText(column.getLabel());
            tableViewerColumn.setLabelProvider((CellLabelProvider)column.getProvider());
            tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TemplatesView.this.tableViewer.setSorter((ViewerSorter)new TableViewerSorter(TemplatesView.this.tableViewer, column.getProvider()));
                }
            });
        }
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        GridLayout gl_composite = new GridLayout(1, true);
        gl_composite.horizontalSpacing = 0;
        gl_composite.marginHeight = 0;
        gl_composite.marginWidth = 0;
        gl_composite.verticalSpacing = 0;
        composite.setLayout((Layout)gl_composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite_1.setLayoutData((Object)gridData);
        this.lblFooter = new Label(composite, 0);
        this.lblFooter.setAlignment(131072);
        this.lblFooter.setSize(this.lblFooter.getSize().x, 80);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.lblFooter.setLayoutData((Object)gridData);
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        try {
            this.update();
        }
        catch (Throwable e) {
            this.lblFooter.setText(this.footerTitle + 0);
            Logger logger = Logger.getLogger(this.getClass());
            logger.error((Object)e.getMessage(), e);
        }
        this.getSite().getWorkbenchWindow().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IViewPart view = TemplatesView.this.getSite().getPage().findView("com.clustercontrol.cloud.ui.views.ScopeView");
                view.getSite().getPage().activate((IWorkbenchPart)view);
                view.getSite().getSelectionProvider().setSelection(view.getSite().getSelectionProvider().getSelection());
                TemplatesView.this.getSite().getPage().activate((IWorkbenchPart)TemplatesView.this);
            }
        });
    }

    private List<ICloudTemplate> getCloudTemplates() {
        if (this.cloudTemplates == null) {
            try {
                this.cloudTemplates = new ArrayList<ICloudTemplate>();
                if (this.cloudTemplateManager != null) {
                    this.cloudTemplateManager.addPropertyObserver2(ICloudTemplateManager.p2.cloudTemplates, this.elementObserver);
                    for (ICloudTemplate cloudTemplate : this.cloudTemplateManager.getCloudTemplates()) {
                        cloudTemplate.addPropertyObserver2(IElement.allProperty, this.propertyObserver);
                    }
                    this.cloudTemplates.addAll(Arrays.asList(this.cloudTemplateManager.getCloudTemplates()));
                }
            }
            catch (Exception e) {
                Logger logger = Logger.getLogger(TemplatesView.class);
                logger.warn((Object)"fail to get cloudTemplates", (Throwable)e);
                this.cloudTemplates = new ArrayList<ICloudTemplate>();
            }
        }
        return this.cloudTemplates;
    }

    private void changeInput(boolean update) {
        if (this.cloudTemplates != null) {
            for (ICloudTemplate cloudTemplate : this.cloudTemplates) {
                cloudTemplate.removePropertyObserver2(IElement.allProperty, this.propertyObserver);
            }
            this.cloudTemplates = null;
        }
        if (this.cloudTemplateManager != null) {
            this.cloudTemplateManager.removePropertyObserver2(ICloudTemplateManager.p2.cloudTemplates, this.elementObserver);
            if (update) {
                this.cloudTemplateManager.update();
            }
        }
        List<ICloudTemplate> cloudTemplates = this.getCloudTemplates();
        this.internalSetInput();
        this.lblFooter.setText(this.footerTitle + cloudTemplates.size());
    }

    public void update() {
        this.changeInput(true);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part instanceof ScopeView && selection instanceof IStructuredSelection) {
            if (this.cloudTemplateManager != null) {
                this.cloudTemplateManager.removePropertyObserver2(ICloudTemplateManager.p2.cloudTemplates, this.elementObserver);
            }
            this.cloudTemplateManager = null;
            if (this.cloudTemplates != null) {
                this.cloudTemplates.clear();
            }
            if (((IStructuredSelection)selection).size() != 1) {
                this.lblHeader.setText(this.headerTitle);
            } else {
                StringBuffer sb = new StringBuffer();
                IFacility facility = (IFacility)((IStructuredSelection)selection).getFirstElement();
                if (facility.getAccountResourceId() != null) {
                    IAccountResource accountResource = Activator.getDefault().getCloudResourceManager().getAccountResourceManager().getAccountResource(facility.getAccountResourceId());
                    this.setAccountResource(accountResource);
                    if (facility.getRegion() != null) {
                        for (IAccountResource.IRegion tmpRegion : accountResource.getRegions()) {
                            if (!tmpRegion.getRegion().equals(facility.getRegion())) continue;
                            this.region = tmpRegion;
                            break;
                        }
                    } else {
                        this.region = null;
                    }
                    this.cloudTemplateManager = accountResource.getCloudTemplateManager();
                    this.cloudTemplateManager.addPropertyObserver2(ICloudTemplateManager.p2.cloudTemplates, this.elementObserver);
                    sb.append(accountResource.getAccountResourceId());
                } else {
                    this.setAccountResource(null);
                    this.region = null;
                }
                this.lblHeader.setText(this.headerTitle + sb.toString());
            }
            this.firePropertyChange(0);
            this.changeInput(false);
        }
    }

    public IAccountResource getAccountResource() {
        return this.accountResource;
    }

    private void setAccountResource(IAccountResource accountResource) {
        this.accountResource = accountResource;
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.getSite().setSelectionProvider(null);
        super.dispose();
    }

    @Override
    public IAccountResource getCurrentAccountResource() {
        return this.getAccountResource();
    }

    @Override
    protected StructuredViewer getViewer() {
        return this.tableViewer;
    }

    public IAccountResource.IRegion getActiveRegion() {
        return this.region;
    }

    private void internalSetInput() {
        if (this.tableViewer != null && this.cloudTemplates != null) {
            if (this.region != null) {
                ArrayList<ICloudTemplate> tmpList = new ArrayList<ICloudTemplate>();
                for (ICloudTemplate template : this.cloudTemplates) {
                    if (!template.getRegion().equals(this.region.getRegion())) continue;
                    tmpList.add(template);
                }
                this.tableViewer.setInput(tmpList);
            } else {
                this.tableViewer.setInput(this.cloudTemplates);
            }
        }
    }

    static /* synthetic */ MessageManager access$600() {
        return bundle_messages;
    }

    private static enum ViewColumn {
        template_id(TemplatesView.access$600().getString("word.template_id"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudTemplate)element).getTemplateId();
            }
        }),
        template_name(TemplatesView.access$600().getString("word.template_name"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudTemplate)element).getTemplateName();
            }
        }),
        template_job_for_create(TemplatesView.access$600().getString("word.template_job_for_create"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudTemplate)element).getLaunchJobId();
            }
        }),
        image_id(TemplatesView.access$600().getString("word.image_id"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudTemplate)element).getImageId();
            }
        }),
        region(TemplatesView.access$600().getString("word.region"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudTemplate)element).getRegion();
            }
        }),
        reg_user(TemplatesView.access$600().getString("word.reg_user"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudTemplate)element).getRegUser();
            }
        }),
        reg_date(TemplatesView.access$600().getString("word.reg_date"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                if (((ICloudTemplate)element).getRegDate() != null) {
                    return format.format(((ICloudTemplate)element).getRegDate());
                }
                return "";
            }
        }),
        update_user(TemplatesView.access$600().getString("word.update_user"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ICloudTemplate)element).getUpdateUser();
            }
        }),
        update_date(TemplatesView.access$600().getString("word.update_date"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                if (((ICloudTemplate)element).getUpdateDate() != null) {
                    return format.format(((ICloudTemplate)element).getUpdateDate());
                }
                return "";
            }
        });

        private String label;
        private ColumnLabelProvider provider;
        private ColumnPixelData pixelData;
        private static SimpleDateFormat format;

        private ViewColumn(String label, ColumnPixelData pixelData, ColumnLabelProvider provider) {
            this.label = label;
            this.pixelData = pixelData;
            this.provider = provider;
        }

        public String getLabel() {
            return this.label;
        }

        public ColumnPixelData getPixelData() {
            return this.pixelData;
        }

        public ColumnLabelProvider getProvider() {
            return this.provider;
        }

        static {
            format = new SimpleDateFormat("yyyy/MM/dd H:mm:ss");
        }
    }
}

