/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.commons.util;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.cloud.commons.util.ControlValidator;
import com.clustercontrol.cloud.commons.util.ControlValidatorImpl;
import com.clustercontrol.cloud.commons.util.ValidateException;
import com.clustercontrol.cloud.commons.util.annotation.Export;
import com.clustercontrol.cloud.commons.util.annotation.Import;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class ControlUtil {
    private static final ControlValidator validator = new ControlValidatorImpl();

    private ControlUtil() {
    }

    public static <T> T deepCopy(T value) {
        Object model = null;
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(byteOut);
            out.writeObject(value);
            ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
            ObjectInputStream in = new ObjectInputStream(byteIn);
            model = in.readObject();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return (T)model;
    }

    public static <T, O> void importObject(T dest, O src) {
        Method[] methods;
        Class<?> dstClass = dest.getClass();
        Class<?> srcClass = src.getClass();
        for (Method method : methods = dstClass.getDeclaredMethods()) {
            for (Annotation annotation : method.getAnnotations()) {
                if (!(annotation instanceof Import) || !method.getName().contains("set")) continue;
                try {
                    String methodName = method.getName().replace("set", "get");
                    Method srcMethod = srcClass.getMethod(methodName, new Class[0]);
                    Object o = srcMethod.invoke(src, new Object[0]);
                    method.invoke(dest, o);
                }
                catch (IllegalArgumentException | NoSuchMethodException e) {
                    Logger.getLogger(ControlUtil.class).debug((Object)("importObject " + src.getClass().getName() + " to " + dest.getClass().getName() + " - " + method.getName() + " : " + e.getMessage()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static <T, O> void exportObject(T src, O dest) {
        Method[] methods;
        Class<?> srcClass = src.getClass();
        Class<?> dstClass = dest.getClass();
        for (Method method : methods = srcClass.getDeclaredMethods()) {
            for (Annotation annotation : method.getAnnotations()) {
                if (!(annotation instanceof Export) || !method.getName().contains("get")) continue;
                try {
                    Object o = method.invoke(src, new Object[0]);
                    String methodName = method.getName().replace("get", "set");
                    Method destMethod = dstClass.getMethod(methodName, method.getReturnType());
                    destMethod.invoke(dest, o);
                }
                catch (IllegalArgumentException | NoSuchMethodException e) {
                    Logger.getLogger(ControlUtil.class).debug((Object)("exportObject " + src.getClass().getName() + " to " + dest.getClass().getName() + " - " + method.getName() + " : " + e.getMessage()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void setRequired(Control ... requiredControls) {
        for (Control requiredControl : requiredControls) {
            if (!(requiredControl instanceof Text)) continue;
            final Text text = (Text)requiredControl;
            if (text.getEnabled() && text.getText().isEmpty()) {
                requiredControl.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
            }
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (text != null && text.getEnabled() && text.getEditable() && text.getText().isEmpty()) {
                        text.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
                    } else if (text != null) {
                        text.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                    }
                }
            });
        }
    }

    public static void setInputRestriction(Text[] texts, final Pattern pattern) {
        for (Text text : texts) {
            text.addVerifyListener(new VerifyListener(){
                Matcher matcher;

                public void verifyText(VerifyEvent e) {
                    if (!e.text.isEmpty()) {
                        String srcText = ((Text)e.getSource()).getText();
                        this.matcher = pattern.matcher(srcText.substring(0, e.start) + e.text + srcText.substring(e.end));
                        if (!this.matcher.matches()) {
                            e.doit = false;
                        }
                    }
                }
            });
        }
    }

    public static void setInputRestriction(Control[] controls, final Pattern pattern) {
        for (Control control : controls) {
            if (control instanceof Text) {
                ((Text)control).addVerifyListener(new VerifyListener(){
                    Matcher matcher;

                    public void verifyText(VerifyEvent e) {
                        if (!e.text.isEmpty()) {
                            String srcText = ((Text)e.getSource()).getText();
                            this.matcher = pattern.matcher(srcText.substring(0, e.start) + e.text + srcText.substring(e.end));
                            if (!this.matcher.matches()) {
                                e.doit = false;
                            }
                        }
                    }
                });
                continue;
            }
            if (!(control instanceof Combo)) continue;
            ((Combo)control).addVerifyListener(new VerifyListener(){
                Matcher matcher;

                public void verifyText(VerifyEvent e) {
                    if (!e.text.isEmpty()) {
                        String srcText = ((Combo)e.getSource()).getText();
                        this.matcher = pattern.matcher(srcText.substring(0, e.start) + e.text + srcText.substring(e.end));
                        if (!this.matcher.matches()) {
                            e.doit = false;
                        }
                    }
                }
            });
        }
    }

    public static void setDigitOnlyInput(Text[] texts) {
        for (Text text : texts) {
            text.addModifyListener(new ModifyListener(){
                Pattern pattern = Pattern.compile("^-?[0-9]+$");
                Matcher matcher;

                public void modifyText(ModifyEvent e) {
                    this.matcher = this.pattern.matcher(((Text)e.getSource()).getText());
                    if (this.matcher.find()) {
                        ((Text)e.getSource()).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                    } else {
                        ((Text)e.getSource()).setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
                    }
                }
            });
            text.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (!Character.isDigit(e.character) && !Character.isISOControl(e.character) && e.character != '-') {
                        e.doit = false;
                    }
                }
            });
        }
    }

    public static void validate(Dialog dialog) throws ValidateException, Exception {
        validator.validate(dialog);
    }
}

