/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.repository.util;

import java.util.Date;;

/**
 * リポジトリに更新があった時刻を管理するクラス
 * 
 * @author Hinemos
 *
 */
public class RepositoryUpdateTime {

	private volatile static Date _updateTime = new Date();

	/**
	 * コンストラクタ
	 */
	private RepositoryUpdateTime(){}

	/**
	 * 更新時刻を更新する
	 */
	public static synchronized void refreshUpdateTime(){
		_updateTime = new Date(System.currentTimeMillis());
	}

	/**
	 * 更新時刻を返却する
	 * @return
	 */
	public static Date getUpdateTime(){
		return _updateTime;
	}
}
