package com.clustercontrol.notify.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.persistence.*;

import com.clustercontrol.commons.util.JpaTransactionManager;



/**
 * The persistent class for the cc_notify_job_info database table.
 * 
 */
@Entity
@Table(name="cc_notify_job_info")
@Cacheable(true)
public class NotifyJobInfoEntity implements Serializable {
	private static final long serialVersionUID = 1L;
	private NotifyJobInfoEntityPK id;
	private Integer jobExecFacilityFlg;
	private Integer jobFailurePriority;
	private String jobId;
	private Integer jobRun;
	private String jobunitId;
	private String jobExecFacilityId;
	private NotifyInfoEntity notifyInfoEntity;

	@Deprecated
	public NotifyJobInfoEntity() {
	}

	public NotifyJobInfoEntity(NotifyJobInfoEntityPK pk,
			NotifyInfoEntity notifyInfoEntity) {
		this.setId(pk);
		EntityManager em = new JpaTransactionManager().getEntityManager();
		em.persist(this);
		this.relateToNotifyInfoEntity(notifyInfoEntity);
	}

	public NotifyJobInfoEntity(String notifyId, Integer priority,
			NotifyInfoEntity notifyInfoEntity) {
		this(new NotifyJobInfoEntityPK(notifyId, priority), notifyInfoEntity);
	}


	@EmbeddedId
	public NotifyJobInfoEntityPK getId() {
		return this.id;
	}

	public void setId(NotifyJobInfoEntityPK id) {
		this.id = id;
	}


	@Column(name="job_exec_facility_flg")
	public Integer getJobExecFacilityFlg() {
		return this.jobExecFacilityFlg;
	}

	public void setJobExecFacilityFlg(Integer jobExecFacilityFlg) {
		this.jobExecFacilityFlg = jobExecFacilityFlg;
	}


	@Column(name="job_failure_priority")
	public Integer getJobFailurePriority() {
		return this.jobFailurePriority;
	}

	public void setJobFailurePriority(Integer jobFailurePriority) {
		this.jobFailurePriority = jobFailurePriority;
	}


	@Column(name="job_id")
	public String getJobId() {
		return this.jobId;
	}

	public void setJobId(String jobId) {
		this.jobId = jobId;
	}


	@Column(name="job_run")
	public Integer getJobRun() {
		return this.jobRun;
	}

	public void setJobRun(Integer jobRun) {
		this.jobRun = jobRun;
	}


	@Column(name="jobunit_id")
	public String getJobunitId() {
		return this.jobunitId;
	}

	public void setJobunitId(String jobunitId) {
		this.jobunitId = jobunitId;
	}


	@Column(name="job_exec_facility")
	public String getJobExecFacilityId() {
		return this.jobExecFacilityId;
	}

	public void setJobExecFacilityId(String jobExecFacilityId) {
		this.jobExecFacilityId = jobExecFacilityId;
	}


	//bi-directional many-to-one association to NotifyInfoEntity
	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="notify_id", insertable=false, updatable=false)
	public NotifyInfoEntity getNotifyInfoEntity() {
		return this.notifyInfoEntity;
	}

	@Deprecated
	public void setNotifyInfoEntity(NotifyInfoEntity notifyInfoEntity) {
		this.notifyInfoEntity = notifyInfoEntity;
	}

	/**
	 * NotifyInfoEntityオブジェクト参照設定<BR>
	 * 
	 * NotifyInfoEntity設定時はSetterに代わりこちらを使用すること。
	 * 
	 * JPAの仕様(JSR 220)では、データ更新に伴うrelationshipの管理はユーザに委ねられており、
	 * INSERTやDELETE時に、そのオブジェクトに対する参照をメンテナンスする処理を実装する。
	 * 
	 * JSR 220 3.2.3 Synchronization to the Database
	 * 
	 * Bidirectional relationships between managed entities will be persisted
	 * based on references held by the owning side of the relationship.
	 * It is the developer’s responsibility to keep the in-memory references
	 * held on the owning side and those held on the inverse side consistent
	 * with each other when they change.
	 */
	public void relateToNotifyInfoEntity(NotifyInfoEntity notifyInfoEntity) {
		this.setNotifyInfoEntity(notifyInfoEntity);
		if (notifyInfoEntity != null) {
			List<NotifyJobInfoEntity> list = notifyInfoEntity.getNotifyJobInfoEntities();
			if (list == null) {
				list = new ArrayList<NotifyJobInfoEntity>();
			} else {
				for(NotifyJobInfoEntity entity : list){
					if (entity.getId().equals(this.getId())) {
						return;
					}
				}
			}
			list.add(this);
			notifyInfoEntity.setNotifyJobInfoEntities(list);
		}
	}


	/**
	 * 削除前処理<BR>
	 * 
	 * JPAの仕様(JSR 220)では、データ更新に伴うrelationshipの管理はユーザに委ねられており、
	 * INSERTやDELETE時に、そのオブジェクトに対する参照をメンテナンスする処理を実装する。
	 * 
	 * JSR 220 3.2.3 Synchronization to the Database
	 * 
	 * Bidirectional relationships between managed entities will be persisted
	 * based on references held by the owning side of the relationship.
	 * It is the developer’s responsibility to keep the in-memory references
	 * held on the owning side and those held on the inverse side consistent
	 * with each other when they change.
	 */
	public void unchain() {

		// NotifyInfoEntity
		if (this.notifyInfoEntity != null) {
			List<NotifyJobInfoEntity> list = this.notifyInfoEntity.getNotifyJobInfoEntities();
			if (list != null) {
				Iterator<NotifyJobInfoEntity> iter = list.iterator();
				while(iter.hasNext()) {
					NotifyJobInfoEntity entity = iter.next();
					if (entity.getId().equals(this.getId())){
						iter.remove();
						break;
					}
				}
			}
		}
	}

}