/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.notify.bean;

import javax.xml.bind.annotation.XmlType;

import com.clustercontrol.monitor.bean.EventConfirmConstant;


/**
 * 通知イベント情報を保持するクラス
 * 
 * @version 3.0.0
 * @since 2.0.0
 */
@XmlType(namespace = "http://notify.ws.clustercontrol.com")
public class NotifyEventInfo  extends NotifyInfoDetail
{
	private static final long serialVersionUID = -5089086735470199399L;

	/**
	 * イベント通知状態。
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */
	private Integer m_eventNormalState = new Integer(EventConfirmConstant.TYPE_UNCONFIRMED);


	/**
	 * コンストラクタ。
	 */
	public NotifyEventInfo() {
	}

	/**
	 * コンストラクタ。
	 * 
	 * @param notifyId 通知ID
	 * @param priority 重要度
	 * @param eventNormalFlg イベント通知フラグ
	 * @param eventNormalState イベント通知状態
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.bean.ValidConstant
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */
	public NotifyEventInfo(
			String notifyId,
			Integer priority,
			Integer eventNormalFlg,
			Integer eventNormalState
			) {

		setNotifyId(notifyId);
		setPriority(priority);
		setValidFlg(eventNormalFlg);
		setEventNormalState(eventNormalState);

	}

	/**
	 * コンストラクタ。
	 * 
	 * @param otherData コピー元の通知情報
	 */
	public NotifyEventInfo( NotifyEventInfo otherData ) {
		setNotifyId(otherData.getNotifyId());
		setPriority(otherData.getPriority());
		setValidFlg(otherData.getValidFlg());
		setEventNormalState(otherData.getEventNormalState());
	}

	/**
	 * イベント通知状態を返します。
	 * 
	 * @return イベント通知状態
	 * 
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */
	public Integer getEventNormalState() {
		return this.m_eventNormalState;
	}

	/**
	 * イベント通知状態を設定します。
	 * 
	 * @param eventNormalState イベント通知状態
	 * 
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */
	public void setEventNormalState( Integer eventNormalState )  {
		this.m_eventNormalState = eventNormalState;
	}

}
