package com.clustercontrol.collectiverun.model;

import java.io.Serializable;
import java.util.Arrays;

import javax.persistence.*;

/**
 * The primary key class for the cc_crun_session_detail database table.
 * 
 */
@Embeddable
public class CrunSessionDetailEntityPK implements Serializable {
	//default serial version id, required for serializable classes.
	private static final long serialVersionUID = 1L;
	private String sessionId;
	private String facilityId;

	public CrunSessionDetailEntityPK() {
	}

	public CrunSessionDetailEntityPK(String sessionId, String facilityId) {
		this.setSessionId(sessionId);
		this.setFacilityId(facilityId);
	}

	@Column(name="session_id")
	public String getSessionId() {
		return this.sessionId;
	}
	public void setSessionId(String sessionId) {
		this.sessionId = sessionId;
	}

	@Column(name="facility_id")
	public String getFacilityId() {
		return this.facilityId;
	}
	public void setFacilityId(String facilityId) {
		this.facilityId = facilityId;
	}

	@Override
	public boolean equals(Object other) {
		if (this == other) {
			return true;
		}
		if (!(other instanceof CrunSessionDetailEntityPK)) {
			return false;
		}
		CrunSessionDetailEntityPK castOther = (CrunSessionDetailEntityPK)other;
		return
				this.sessionId.equals(castOther.sessionId)
				&& this.facilityId.equals(castOther.facilityId);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int hash = 17;
		hash = hash * prime + this.sessionId.hashCode();
		hash = hash * prime + this.facilityId.hashCode();

		return hash;
	}

	@Override
	public String toString() {
		String[] names = {
				"sessionId",
				"facilityId"
		};
		String[] values = {
				this.sessionId,
				this.facilityId
		};
		return Arrays.toString(names) + " = " + Arrays.toString(values);
	}
}