package com.clustercontrol.snmptrap.util;

import java.util.List;

import javax.xml.ws.WebServiceException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.util.EndpointManager;
import com.clustercontrol.util.EndpointManager.EndpointSetting;
import com.clustercontrol.ws.monitor.HinemosUnknown_Exception;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;
import com.clustercontrol.ws.monitor.InvalidUserPass_Exception;
import com.clustercontrol.ws.monitor.MonitorNotFound_Exception;
import com.clustercontrol.ws.monitor.MonitorSnmpTrapEndpoint;
import com.clustercontrol.ws.monitor.SnmpTrapMasterInfo;
import com.clustercontrol.ws.monitor.SnmpTrapMibMasterData;

/**
 * Hinemosマネージャとの通信をするクラス。
 * HAのような複数マネージャ対応のため、このクラスを実装する。
 * 
 * Hinemosマネージャと通信できない場合は、WebServiceExceptionがthrowされる。
 * WebServiceExeptionが出力された場合は、もう一台のマネージャと通信する。
 */
public class MonitorSnmpTrapEndpointWrapper {

	// ログ
	private static Log m_log = LogFactory.getLog( MonitorSnmpTrapEndpointWrapper.class );

	public static List<String> getMibList()
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorSnmpTrapEndpoint()) {
			try {
				MonitorSnmpTrapEndpoint endpoint = (MonitorSnmpTrapEndpoint) endpointSetting.getEndpoint();
				return endpoint.getMibList();
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getMibList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<SnmpTrapMasterInfo> getMasterList(String mib)
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorSnmpTrapEndpoint()) {
			try {
				MonitorSnmpTrapEndpoint endpoint = (MonitorSnmpTrapEndpoint) endpointSetting.getEndpoint();
				return endpoint.getMasterList(mib);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getMasterList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static SnmpTrapMibMasterData getMib(String Mib)
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorSnmpTrapEndpoint()) {
			try {
				MonitorSnmpTrapEndpoint endpoint = (MonitorSnmpTrapEndpoint) endpointSetting.getEndpoint();
				return endpoint.getMib(Mib);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getMib(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static boolean addMibMaster(SnmpTrapMibMasterData MibData)
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorSnmpTrapEndpoint()) {
			try {
				MonitorSnmpTrapEndpoint endpoint = (MonitorSnmpTrapEndpoint) endpointSetting.getEndpoint();
				return endpoint.addMibMaster(MibData);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("addMibMaster(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static boolean modifyMibMaster(SnmpTrapMibMasterData MibData)
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorSnmpTrapEndpoint()) {
			try {
				MonitorSnmpTrapEndpoint endpoint = (MonitorSnmpTrapEndpoint) endpointSetting.getEndpoint();
				return endpoint.modifyMibMaster(MibData);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("modifyMibMaster(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static boolean deleteMibMaster(String Mib)
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorSnmpTrapEndpoint()) {
			try {
				MonitorSnmpTrapEndpoint endpoint = (MonitorSnmpTrapEndpoint) endpointSetting.getEndpoint();
				return endpoint.deleteMibMaster(Mib);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("deleteMibMaster(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static boolean addOidMaster(SnmpTrapMasterInfo Oid)
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorSnmpTrapEndpoint()) {
			try {
				MonitorSnmpTrapEndpoint endpoint = (MonitorSnmpTrapEndpoint) endpointSetting.getEndpoint();
				return endpoint.addOidMaster(Oid);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("addOidMaster(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static boolean modifyOidMaster(SnmpTrapMasterInfo Oid)
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorSnmpTrapEndpoint()) {
			try {
				MonitorSnmpTrapEndpoint endpoint = (MonitorSnmpTrapEndpoint) endpointSetting.getEndpoint();
				return endpoint.modifyOidMaster(Oid);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("modifyOidMaster(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static boolean deleteOidMaster(SnmpTrapMasterInfo oid)
			throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getMonitorSnmpTrapEndpoint()) {
			try {
				MonitorSnmpTrapEndpoint endpoint = (MonitorSnmpTrapEndpoint) endpointSetting.getEndpoint();
				return endpoint.deleteOidMaster(oid);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("deleteOidMaster(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}
}
