/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.notify.mail.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.notify.mail.view.MailTemplateListView;

/**
 * メールテンプレート[一覧]ビューの更新アクションクラス<BR>
 * 
 * @version 4.0.0
 * @since 4.0.0
 */
public class MailTemplateRefreshAction implements IViewActionDelegate {

	/** アクションID */
	public static final String ID = "com.clustercontrol.notify.mail.view.action.MailTemplateRefreshAction";

	/** ビュー */
	private IViewPart viewPart;


	@Override
	public void run(IAction action) {
		// ビューの更新
		MailTemplateListView view = (MailTemplateListView) this.viewPart.getAdapter(MailTemplateListView.class);
		view.update();
	}

	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		// TODO Auto-generated method stub

	}

	@Override
	public void init(IViewPart viewPart) {
		this.viewPart = viewPart;
	}

}
