/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.monitor.view;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;

import com.clustercontrol.accesscontrol.util.ObjectBean;
import com.clustercontrol.bean.HinemosModuleConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.composite.MonitorListComposite;
import com.clustercontrol.monitor.composite.action.MonitorListSelectionChangedListener;
import com.clustercontrol.monitor.run.action.GetMonitorListTableDefine;
import com.clustercontrol.monitor.view.action.CollectorDisableAction;
import com.clustercontrol.monitor.view.action.CollectorEnableAction;
import com.clustercontrol.monitor.view.action.MonitorAddAction;
import com.clustercontrol.monitor.view.action.MonitorCopyAction;
import com.clustercontrol.monitor.view.action.MonitorDeleteAction;
import com.clustercontrol.monitor.view.action.MonitorDisableAction;
import com.clustercontrol.monitor.view.action.MonitorEnableAction;
import com.clustercontrol.monitor.view.action.MonitorModifyAction;
import com.clustercontrol.view.CommonViewPart;
import com.clustercontrol.view.ObjectPrivilegeTargetListView;
import com.clustercontrol.view.action.ObjectPrivilegeAction;

/**
 * 監視[一覧]ビュークラス<BR>
 * 
 * @version 4.0.0
 * @since 4.0.0
 */
public class MonitorListView extends CommonViewPart implements ObjectPrivilegeTargetListView {

	/** 監視[一覧]ビューID */
	public static final String ID = "com.clustercontrol.monitor.view.MonitorListView";

	/** 監視設定一覧コンポジット */
	private MonitorListComposite composite = null;

	/** 検索条件 */
	private Property condition = null;

	/**
	 * コンストラクタ
	 */
	public MonitorListView() {
		super();
	}

	/**
	 * ViewPartへのコントロール作成処理<BR>
	 * 
	 * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public void createPartControl(Composite parent) {
		GridLayout layout = new GridLayout(1, true);
		parent.setLayout(layout);
		layout.marginHeight = 0;
		layout.marginWidth = 0;

		composite = new MonitorListComposite(parent, SWT.NONE);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		this.composite.setLayoutData(gridData);

		//ポップアップメニュー作成
		createContextMenu();

		// ボタン（アクション）を制御するリスナーを登録
		this.composite.getTableViewer().addSelectionChangedListener(
				new MonitorListSelectionChangedListener());

		this.update();
	}

	/**
	 * コンテキストメニューを作成します。
	 * 
	 * @see org.eclipse.jface.action.MenuManager
	 * @see org.eclipse.swt.widgets.Menu
	 */
	private void createContextMenu() {
		MenuManager menuManager = new MenuManager();
		menuManager.setRemoveAllWhenShown(true);
		menuManager.addMenuListener(new IMenuListener() {
			/* (non-Javadoc)
			 * @see org.eclipse.jface.action.IMenuListener#menuAboutToShow(org.eclipse.jface.action.IMenuManager)
			 */
			@Override
			public void menuAboutToShow(IMenuManager manager) {
				//メニュー項目設定
				fillContextMenu(manager);
			}
		});

		Menu menu = menuManager.createContextMenu(composite.getTable());
		composite.getTable().setMenu(menu);
	}

	/**
	 * コンテキストメニューに項目を追加します。
	 * 
	 * @param manager メニューマネージャ
	 * 
	 * @see org.eclipse.jface.action.IToolBarManager
	 * @see org.eclipse.jface.action.IMenuManager
	 */
	private void fillContextMenu(IMenuManager manager) {
		//ビューのアクションのインスタンスを取得
		IToolBarManager toolbar =
				this.getViewSite().getActionBars().getToolBarManager();
		ActionContributionItem monitorAdd =
				(ActionContributionItem) toolbar.find(MonitorAddAction.ID);
		ActionContributionItem monitorModify =
				(ActionContributionItem) toolbar.find(MonitorModifyAction.ID);
		ActionContributionItem monitorDelete =
				(ActionContributionItem) toolbar.find(MonitorDeleteAction.ID);
		ActionContributionItem monitorCopy =
				(ActionContributionItem) toolbar.find(MonitorCopyAction.ID);
		ActionContributionItem monitorEnable =
				(ActionContributionItem) toolbar.find(MonitorEnableAction.ID);
		ActionContributionItem monitorDisable =
				(ActionContributionItem) toolbar.find(MonitorDisableAction.ID);
		ActionContributionItem collectorEnable =
				(ActionContributionItem) toolbar.find(CollectorEnableAction.ID);
		ActionContributionItem collectorDisable =
				(ActionContributionItem) toolbar.find(CollectorDisableAction.ID);
		ActionContributionItem objPrivilege =
				(ActionContributionItem) toolbar.find(ObjectPrivilegeAction.ID);

		//ポップアップメニューにアクションを追加
		manager.add(monitorAdd.getAction());
		manager.add(monitorModify.getAction());
		manager.add(monitorDelete.getAction());
		manager.add(new Separator());
		manager.add(monitorCopy.getAction());
		manager.add(new Separator());
		manager.add(monitorEnable.getAction());
		manager.add(monitorDisable.getAction());
		manager.add(collectorEnable.getAction());
		manager.add(collectorDisable.getAction());
		manager.add(new Separator());
		manager.add(objPrivilege.getAction());
	}

	/**
	 * 追加コンポジットを返します。
	 * 
	 * @return 追加コンポジット
	 */
	public Composite getListComposite() {
		return this.composite;
	}

	/**
	 * 検索条件にヒットした監視設定の一覧を表示します。
	 * <p>
	 * 
	 * conditionがnullの場合、全監視設定を表示します。
	 * 
	 * @param condition
	 *            検索条件
	 */
	public void update(Property condition) {
		this.condition = condition;

		this.update();
	}

	/**
	 * ビューを更新します。
	 * <p>
	 * 
	 * 検索条件が事前に設定されている場合、その条件にヒットする監視設定の一覧を 表示します <br>
	 * 検索条件が設定されていない場合は、全監視設定を表示します。
	 */
	@Override
	public void update() {
		this.composite.update(this.condition);
	}

	/**
	 * ビューのアクションの有効/無効を設定します。
	 * 
	 * @param num 選択イベント数
	 * @param selection ボタン（アクション）を有効にするための情報
	 */
	public void setEnabledAction(int num, ISelection selection) {
		//ビューアクションの使用可/不可を設定
		super.setEnabledAction(ObjectPrivilegeAction.ID, selection);
		super.setEnabledAction(MonitorCopyAction.ID, selection);
		super.setEnabledAction(MonitorDeleteAction.ID, selection);
		super.setEnabledAction(MonitorModifyAction.ID, selection);
		super.setEnabledAction(MonitorDisableAction.ID, selection);
		super.setEnabledAction(MonitorEnableAction.ID, selection);
		super.setEnabledAction(CollectorDisableAction.ID, selection);
		super.setEnabledAction(CollectorEnableAction.ID, selection);

		if(num > 0){
			super.setEnabledAction(MonitorDisableAction.ID, true);
			super.setEnabledAction(MonitorEnableAction.ID, true);
			super.setEnabledAction(CollectorDisableAction.ID, true);
			super.setEnabledAction(CollectorEnableAction.ID, true);
			super.setEnabledAction(ObjectPrivilegeAction.ID, true);

			if(num == 1){
				super.setEnabledAction(MonitorCopyAction.ID, true);
				super.setEnabledAction(MonitorDeleteAction.ID, true);
				super.setEnabledAction(MonitorModifyAction.ID, true);
			}else{
				super.setEnabledAction(MonitorCopyAction.ID, false);
				super.setEnabledAction(MonitorDeleteAction.ID, false);
				super.setEnabledAction(MonitorModifyAction.ID, false);
			}
		} else {
			super.setEnabledAction(ObjectPrivilegeAction.ID, false);
			super.setEnabledAction(MonitorCopyAction.ID, false);
			super.setEnabledAction(MonitorDeleteAction.ID, false);
			super.setEnabledAction(MonitorModifyAction.ID, false);
			super.setEnabledAction(MonitorDisableAction.ID, false);
			super.setEnabledAction(MonitorEnableAction.ID, false);
			super.setEnabledAction(CollectorDisableAction.ID, false);
			super.setEnabledAction(CollectorEnableAction.ID, false);
		}
	}

	@Override
	public List<ObjectBean> getSelectedObjectBeans() {
		StructuredSelection selection = (StructuredSelection) this.composite.getTableViewer().getSelection();
		Object [] objs = selection.toArray();

		String objectType = HinemosModuleConstant.MONITOR;
		String objectId = null;
		List<ObjectBean> objectBeans = new ArrayList<ObjectBean>();
		for (Object obj : objs) {
			objectId = (String) ((List)obj).get(GetMonitorListTableDefine.MONITOR_ID);
			ObjectBean objectBean = new ObjectBean(objectType, objectId);
			objectBeans.add(objectBean);
		}
		return objectBeans;
	}

	@Override
	public String getSelectedOwnerRoleId() {
		StructuredSelection selection = (StructuredSelection) this.composite.getTableViewer().getSelection();

		List list = (List) selection.getFirstElement();
		String id = null;
		if (list != null) {
			id = (String) list.get(GetMonitorListTableDefine.OWNER_ROLE);
		}
		return id;
	}
}
