/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.monitor.run.viewer;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

import com.clustercontrol.bean.ProcessConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.monitor.run.action.GetStringFilterTableDefine;
import com.clustercontrol.ws.monitor.MonitorStringValueInfo;

/**
 * 文字列監視の判定情報一覧のラベルプロバイダークラス<BR>
 * 
 * @version 3.0.0
 * @since 2.1.0
 */
public class StringValueListTableLabelProvider extends LabelProvider implements ITableLabelProvider {

	/**
	 * カラム文字列を返します。
	 * 
	 * @since 2.1.0
	 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnText(java.lang.Object, int)
	 */
	@Override
	public String getColumnText(Object element, int columnIndex) {

		if (element instanceof MonitorStringValueInfo) {
			MonitorStringValueInfo filterInfo = (MonitorStringValueInfo) element;

			if (columnIndex == GetStringFilterTableDefine.ORDER_NO) {
				return Integer.toString(filterInfo.getOrderNo());

			} else if (columnIndex == GetStringFilterTableDefine.PROCESS_TYPE) {
				return ProcessConstant.typeToString(filterInfo.getProcessType());

			} else if (columnIndex == GetStringFilterTableDefine.PATTERN_STRING) {
				if (filterInfo.getPattern() != null) {
					return filterInfo.getPattern();
				}
			} else if (columnIndex == GetStringFilterTableDefine.DESCRIPTION) {
				if (filterInfo.getDescription() != null) {
					return filterInfo.getDescription();
				}
			} else if (columnIndex == GetStringFilterTableDefine.VALID_FLG) {
				//				if (filterInfo.isNotifyId() != null) {
				return ValidConstant.typeToString(ValidConstant.booleanToType(filterInfo.isValidFlg()));
				//				}
			}
		}
		return "";
	}

	/**
	 * カラムイメージ(アイコン)を返します。
	 * 
	 * @since 2.1.0
	 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnImage(java.lang.Object, int)
	 */
	@Override
	public Image getColumnImage(Object element, int columnIndex) {
		return null;
	}
}