/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.view.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.jobmanagement.bean.JobConstant;
import com.clustercontrol.jobmanagement.composite.JobTreeComposite;
import com.clustercontrol.jobmanagement.util.JobEditStateUtil;
import com.clustercontrol.jobmanagement.util.JobPropertyUtil;
import com.clustercontrol.jobmanagement.util.JobTreeItemUtil;
import com.clustercontrol.jobmanagement.util.JobUtil;
import com.clustercontrol.jobmanagement.view.JobListView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import com.clustercontrol.ws.jobmanagement.OtherUserGetLock_Exception;

/**
 * ジョブ貼り付けするクライアント側アクションクラス<BR>
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class PasteJobAction extends Action {

	// ログ
	private static Log m_log = LogFactory.getLog( PasteJobAction.class );

	/** ビュー */
	private IViewPart m_view;

	/**
	 * コンストラクタ
	 * 
	 * @param view ビュー
	 */
	public PasteJobAction(IViewPart view) {
		m_view = view;

		setText(Messages.getString("paste"));
		setToolTipText(Messages.getString("paste"));
	}

	/**
	 * ジョブ[一覧]ビューにて選択されたジョブツリーアイテムを取得します。<BR>
	 * ジョブ[一覧]ビューにコピー元のジョブツリーアイテムとして設定します。
	 * <p>
	 * <ol>
	 * <li>ジョブ[一覧]ビューにて選択されたジョブツリーアイテムを取得します。</li>
	 * <li>ジョブ[一覧]ビューからコピー元のジョブツリーアイテムを取得します。</li>
	 * <li>コピー元ジョブツリーアイテムから、ジョブツリーアイテムのコピーを作成します。</li>
	 * <li>ジョブツリーアイテムのコピーを選択されたジョブツリーアイテムの子として追加します。</li>
	 * </ol>
	 * 
	 * @see org.eclipse.jface.action.IAction#run()
	 * @see com.clustercontrol.jobmanagement.util.JobUtil#copy(JobTreeItem, JobTreeItem)
	 * @see com.clustercontrol.jobmanagement.bean.JobTreeItem#addChildren(JobTreeItem)
	 */
	@Override
	public void run() {
		JobListView view = (JobListView)m_view.getAdapter(JobListView.class);
		JobTreeItem selectItem = view.getSelectJobTreeItem();
		JobTreeItem sourceItem = view.getCopyJobTreeItem();
		if(selectItem instanceof JobTreeItem &&
				sourceItem instanceof JobTreeItem){

			boolean copy = false;
			if(sourceItem.getData().getType() == JobConstant.TYPE_JOBUNIT){
				if(selectItem.getData().getType() == JobConstant.TYPE_COMPOSITE){
					copy = true;
				}
			}
			else if(sourceItem.getData().getType() == JobConstant.TYPE_JOBNET){
				if(selectItem.getData().getType() == JobConstant.TYPE_JOBUNIT ||
						selectItem.getData().getType() == JobConstant.TYPE_JOBNET){
					copy = true;
				}
			}
			else if(sourceItem.getData().getType() == JobConstant.TYPE_JOB){
				if(selectItem.getData().getType() == JobConstant.TYPE_JOBUNIT ||
						selectItem.getData().getType() == JobConstant.TYPE_JOBNET){
					copy = true;
				}
			}
			else if(sourceItem.getData().getType() == JobConstant.TYPE_FILEJOB){
				if(selectItem.getData().getType() == JobConstant.TYPE_JOBUNIT ||
						selectItem.getData().getType() == JobConstant.TYPE_JOBNET){
					copy = true;
				}
			}//参照ジョブ
			else if(sourceItem.getData().getType() == JobConstant.TYPE_REFERJOB){
				if(selectItem.getData().getType() == JobConstant.TYPE_JOBUNIT ||
						selectItem.getData().getType() == JobConstant.TYPE_JOBNET){
					copy = true;
				}
			}
			if(copy){
				JobTreeComposite tree = view.getJobTreeComposite();
				JobTreeItem top = (JobTreeItem)tree.getTreeViewer().getInput();
				//m_log.debug("run() setJobunitId = " + selectItem.getData().getJobunitId());
				JobTreeItem copyItem = null;

				// コピー元のジョブツリーのプロパティーがFullでない場合があるので、
				// ここでコピーしておく。
				JobPropertyUtil.setJobFullTree(sourceItem);
				if(sourceItem.getData().getType() == JobConstant.TYPE_JOBUNIT){
					copyItem = JobUtil.copy(sourceItem, top, sourceItem.getData().getId(), sourceItem.getData().getOwnerRoleId());
					Integer result = null;
					try {
						result =JobUtil.getEditLock(copyItem.getData().getJobunitId(), null, false);
					} catch (OtherUserGetLock_Exception e) {
						// 他のユーザがロックを取得している
						String message = e.getMessage();
						if (MessageDialog.openQuestion(
								null,
								Messages.getString("confirmed"),
								message)) {
							try {
								result = JobUtil.getEditLock(copyItem.getData().getJobunitId(), null, true);
							} catch (Exception e1) {
								// ここには絶対にこないはず
								m_log.error("run() : logical error");
							}
						}
					}
					JobEditStateUtil.addLockedJobunit(copyItem.getData(), null, result);
				} else{
					copyItem = JobUtil.copy(sourceItem, top, selectItem.getData().getJobunitId(),selectItem.getData().getOwnerRoleId());
				}
				JobTreeItemUtil.addChildren(selectItem, copyItem);
				JobEditStateUtil.addEditedJobunit(copyItem);

				tree.getTreeViewer().sort(selectItem);
				tree.refresh(selectItem);
				tree.getTreeViewer().setSelection(
						new StructuredSelection(selectItem), true);
			} else {
				MessageDialog.openError(null, Messages.getString("failed"),
						Messages.getString("paste") + Messages.getString("failed"));
			}
		}
	}
}
