/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.view;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;

import com.clustercontrol.accesscontrol.util.ObjectBean;
import com.clustercontrol.bean.HinemosModuleConstant;
import com.clustercontrol.jobmanagement.action.GetJobKickTableDefine;
import com.clustercontrol.jobmanagement.bean.JobTriggerTypeConstant;
import com.clustercontrol.jobmanagement.composite.JobKickListComposite;
import com.clustercontrol.jobmanagement.view.action.CopyJobKickAction;
import com.clustercontrol.jobmanagement.view.action.CreateFileCheckAction;
import com.clustercontrol.jobmanagement.view.action.CreateScheduleAction;
import com.clustercontrol.jobmanagement.view.action.DeleteJobKickAction;
import com.clustercontrol.jobmanagement.view.action.DisableJobKickAction;
import com.clustercontrol.jobmanagement.view.action.EnableJobKickAction;
import com.clustercontrol.jobmanagement.view.action.ModifyJobKickAction;
import com.clustercontrol.view.CommonViewPart;
import com.clustercontrol.view.ObjectPrivilegeTargetListView;
import com.clustercontrol.view.action.ObjectPrivilegeAction;

/**
 * ジョブ[実行契機]ビュークラスです。
 * 
 * @version 4.1.0
 * @since 1.0.0
 */
public class JobKickListView extends CommonViewPart implements ObjectPrivilegeTargetListView {
	/** ビューID */
	public static final String ID = "com.clustercontrol.jobmanagement.view.JobKickListView";
	/** ジョブ[実行契機]ビュー用のコンポジット */
	private JobKickListComposite m_jobKickList = null;

	/**
	 * コンストラクタ
	 */
	public JobKickListView() {
		super();
	}

	/**
	 * ビューを構築します。
	 * 
	 * @param parent 親コンポジット
	 * 
	 * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
	 * @see #createContextMenu()
	 * @see #update()
	 */
	@Override
	public void createPartControl(Composite parent) {
		GridLayout layout = new GridLayout(1, true);
		parent.setLayout(layout);
		layout.marginHeight = 0;
		layout.marginWidth = 0;

		m_jobKickList = new JobKickListComposite(parent, SWT.NONE);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		m_jobKickList.setLayoutData(gridData);

		//ポップアップメニュー作成
		createContextMenu();

		//ビューの更新
		this.update();
	}

	/**
	 * コンテキストメニューを作成します。
	 * 
	 * @see org.eclipse.jface.action.MenuManager
	 * @see org.eclipse.swt.widgets.Menu
	 */
	private void createContextMenu() {
		MenuManager menuManager = new MenuManager();
		menuManager.setRemoveAllWhenShown(true);
		menuManager.addMenuListener(new IMenuListener() {
			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.jface.action.IMenuListener#menuAboutToShow(org.eclipse.jface.action.IMenuManager)
			 */
			@Override
			public void menuAboutToShow(IMenuManager manager) {
				//メニュー項目設定
				fillContextMenu(manager);
			}
		});

		Menu menu = menuManager.createContextMenu(m_jobKickList.getTable());
		m_jobKickList.getTable().setMenu(menu);
	}

	/**
	 * コンテキストメニューに項目を追加します。
	 * 
	 * @param manager メニューマネージャ
	 * 
	 * @see org.eclipse.jface.action.IToolBarManager
	 * @see org.eclipse.jface.action.IMenuManager
	 */
	private void fillContextMenu(IMenuManager manager) {
		//ビューのアクションのインスタンスを取得
		IToolBarManager toolbar = this.getViewSite().getActionBars()
				.getToolBarManager();
		ActionContributionItem createFileCheckAction = (ActionContributionItem) toolbar
				.find(CreateFileCheckAction.ID);
		ActionContributionItem createScheduleAction = (ActionContributionItem) toolbar
				.find(CreateScheduleAction.ID);
		ActionContributionItem modifyScheduleAction = (ActionContributionItem) toolbar
				.find(ModifyJobKickAction.ID);
		ActionContributionItem deleteScheduleAction = (ActionContributionItem) toolbar
				.find(DeleteJobKickAction.ID);
		ActionContributionItem copyJobKickAction = (ActionContributionItem) toolbar
				.find(CopyJobKickAction.ID);
		ActionContributionItem enableJobKickAction = (ActionContributionItem) toolbar
				.find(EnableJobKickAction.ID);
		ActionContributionItem disableJobKickAction = (ActionContributionItem) toolbar
				.find(DisableJobKickAction.ID);
		ActionContributionItem objPrivilege =
				(ActionContributionItem) toolbar.find(ObjectPrivilegeAction.ID);

		//ポップアップメニューにアクションを追加
		manager.add(createFileCheckAction.getAction());
		manager.add(createScheduleAction.getAction());
		manager.add(modifyScheduleAction.getAction());
		manager.add(deleteScheduleAction.getAction());
		manager.add(copyJobKickAction.getAction());
		manager.add(enableJobKickAction.getAction());
		manager.add(disableJobKickAction.getAction());
		manager.add(new Separator());
		manager.add(objPrivilege.getAction());
	}

	/**
	 * ビューを更新します。
	 * 
	 * @see com.clustercontrol.jobmanagement.composite.JobKickListComposite#update()
	 */
	@Override
	public void update() {
		m_jobKickList.update();
	}

	/**
	 * ジョブ[実行契機]ビュー用のコンポジットを返します。
	 * 
	 * @return ジョブ[実行契機]ビュー用のコンポジット
	 */
	public JobKickListComposite getComposite() {
		return m_jobKickList;
	}

	/**
	 * ビューのアクションの有効/無効を設定します。
	 * 
	 * @param num 選択イベント数
	 * @param selection ボタン（アクション）を有効にするための情報
	 */
	public void setEnabledAction(int num, ISelection selection) {
		//ビューアクションの使用可/不可を設定
		super.setEnabledAction(ObjectPrivilegeAction.ID, selection);
		super.setEnabledAction(ModifyJobKickAction.ID, selection);
		super.setEnabledAction(DeleteJobKickAction.ID, selection);
		super.setEnabledAction(EnableJobKickAction.ID, selection);
		super.setEnabledAction(DisableJobKickAction.ID, selection);

		super.setEnabledAction(CopyJobKickAction.ID, selection);

		if (num > 0){
			super.setEnabledAction(EnableJobKickAction.ID, true);
			super.setEnabledAction(DisableJobKickAction.ID, true);
			super.setEnabledAction(CopyJobKickAction.ID, true);
			super.setEnabledAction(ObjectPrivilegeAction.ID, true);

			if(num == 1){
				super.setEnabledAction(ModifyJobKickAction.ID, true);
				super.setEnabledAction(DeleteJobKickAction.ID, true);
				super.setEnabledAction(CopyJobKickAction.ID, true);
			}else{
				super.setEnabledAction(ModifyJobKickAction.ID, false);
				super.setEnabledAction(DeleteJobKickAction.ID, false);
				super.setEnabledAction(CopyJobKickAction.ID, false);
			}

		} else {
			super.setEnabledAction(EnableJobKickAction.ID, false);
			super.setEnabledAction(DisableJobKickAction.ID, false);
			super.setEnabledAction(ObjectPrivilegeAction.ID, false);
			super.setEnabledAction(ModifyJobKickAction.ID, false);
			super.setEnabledAction(DeleteJobKickAction.ID, false);
			super.setEnabledAction(CopyJobKickAction.ID, false);
		}
	}
	public String getSelectedId() {
		StructuredSelection selection = (StructuredSelection) this.m_jobKickList.getTableViewer().getSelection();

		List list = (List) selection.getFirstElement();
		String id = null;
		if (list != null) {
			id = (String) list.get(GetJobKickTableDefine.SCHE_ID);
		}
		return id;
	}

	@Override
	public List<ObjectBean> getSelectedObjectBeans() {
		StructuredSelection selection = (StructuredSelection) this.m_jobKickList.getTableViewer().getSelection();
		Object [] objs = selection.toArray();

		String objectType = null;
		String objectId = null;
		List<ObjectBean> objectBeans = new ArrayList<ObjectBean>();
		for (Object obj : objs) {
			objectId = (String) ((List)obj).get(GetJobKickTableDefine.SCHE_ID);

			String type = (String) ((List)obj).get(GetJobKickTableDefine.TYPE);
			int TypeNum = JobTriggerTypeConstant.stringToType(type);
			if(TypeNum == JobTriggerTypeConstant.TYPE_SCHEDULE){
				objectType = HinemosModuleConstant.JOB_SCHEDULE;
			} else if (TypeNum == JobTriggerTypeConstant.TYPE_FILECHECK) {
				objectType = HinemosModuleConstant.JOB_FILE_CHECK;
			}

			ObjectBean objectBean = new ObjectBean(objectType, objectId);
			objectBeans.add(objectBean);
		}
		return objectBeans;
	}

	@Override
	public String getSelectedOwnerRoleId() {
		StructuredSelection selection = (StructuredSelection) this.m_jobKickList.getTableViewer().getSelection();

		List list = (List) selection.getFirstElement();
		String id = null;
		if (list != null) {
			id = (String) list.get(GetJobKickTableDefine.OWNER_ROLE);
		}
		return id;
	}
}