/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.view;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.bean.Property;
import com.clustercontrol.collectiverun.composite.HistoryComposite;
import com.clustercontrol.collectiverun.preference.CollectiveRunPreferencePage;
import com.clustercontrol.view.AutoUpdateView;

/**
 * 一括制御[履歴]ビュークラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 * 
 */
public class HistoryView extends AutoUpdateView {
	public static final String ID = "com.clustercontrol.collectiverun.view.HistoryView";

	/** フィルタ条件 */
	private Property m_condition = null;

	/** 履歴コンポジット */
	private HistoryComposite m_history = null;

	/**
	 * コンストラクタ
	 */
	public HistoryView() {
		super();
	}

	/**
	 * ViewPartへのコントロール作成処理
	 * 
	 * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public void createPartControl(Composite parent) {
		GridLayout layout = new GridLayout(1, true);
		parent.setLayout(layout);
		layout.marginHeight = 0;
		layout.marginWidth = 0;

		//履歴作成
		m_history = new HistoryComposite(parent, SWT.NONE);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		m_history.setLayoutData(gridData);

		this.update();

		// 設定情報反映
		IPreferenceStore store = ClusterControlPlugin.getDefault()
				.getPreferenceStore();

		this.setInterval(store.getInt(CollectiveRunPreferencePage.P_HISTORY_UPDATE_CYCLE));

		if (store.getBoolean(CollectiveRunPreferencePage.P_HISTORY_UPDATE_FLG)) {
			this.startAutoReload();
		}
	}

	/**
	 * 履歴コンポジット取得
	 * 
	 * @return historyComposite
	 * 
	 */
	public HistoryComposite getComposite() {
		return this.m_history;
	}

	/**
	 * フィルタ条件取得
	 * 
	 * @return フィルタ条件
	 */
	public Property getFilterCondition() {
		return m_condition;
	}

	/**
	 * フィルタ条件設定
	 * 
	 * @param condition
	 *            フィルタ条件
	 */
	public void setFilterCondition(Property condition) {
		m_condition = condition;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.clustercontrol.view.AutoUpdateView#update()
	 */
	@Override
	public void update() {
		if (m_condition == null) {
			m_history.update();
		} else {
			m_history.update(m_condition);
		}
	}

	/**
	 * アダプターとして要求された場合、自身のインスタンスを渡します。
	 * 
	 * @param cls
	 *            クラスのインスタンス
	 * @return 自身のインスタンス
	 */
	@Override
	public Object getAdapter(Class cls) {
		if (cls.isInstance(this)) {
			return this;
		} else {
			return super.getAdapter(cls);
		}
	}
}