/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.action;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.collectiverun.util.CollectiveRunEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.collectiverun.CommandInfo;
import com.clustercontrol.ws.collectiverun.CommandParameterInfo;
import com.clustercontrol.ws.collectiverun.InvalidRole_Exception;
import com.clustercontrol.ws.collectiverun.ItemInfo;
import com.clustercontrol.ws.collectiverun.ParameterInfo;
import com.clustercontrol.ws.collectiverun.ParameterSelectInfo;
import com.clustercontrol.ws.collectiverun.TypeInfo;

/**
 * 一括制御のマスタ情報を更新するクライアント側アクションクラス<BR>
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class ModifyMaster {

	/**
	 * 一括制御のマスタ情報を更新します。<BR>
	 * 
	 * @param info
	 * @param parentInfo
	 * @return
	 */
	public boolean update(ItemInfo info, ItemInfo parentInfo) {

		boolean result = false;
		try {
			CollectiveRunEndpointWrapper.updateMaster(info, parentInfo);
			result = true;
		} catch (Exception e) {
			String errMessage = "";
			if (e instanceof InvalidRole_Exception) {
				// 権限なし
				MessageDialog.openInformation(null, Messages.getString("message"),
						Messages.getString("message.accesscontrol.16"));
			} else {
				errMessage = ", " + e.getMessage();
			}

			//エラー時、エラーダイアログを表示する
			Object[] args = { info.getName() };
			String messageKey = "";
			if (info instanceof CommandInfo) {
				messageKey = "message.collective.run.12";
			} else if (info instanceof CommandParameterInfo
					|| info instanceof ParameterInfo) {
				messageKey = "message.collective.run.13";
			} else if (info instanceof ParameterSelectInfo) {
				messageKey = "message.collective.run.14";
			} else if (info instanceof TypeInfo) {
				messageKey = "message.collective.run.11";
			}
			MessageDialog.openError(null,
					Messages.getString("message"),
					Messages.getString(messageKey, args) + errMessage);
		}

		return result;
	}
}
