/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.calendar.composite;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import com.clustercontrol.calendar.util.CalendarEndpointWrapper;
import com.clustercontrol.monitor.run.dialog.CommonMonitorDialog;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.calendar.CalendarInfo;
import com.clustercontrol.ws.calendar.InvalidRole_Exception;


/**
 * カレンダIDコンポジットクラス<BR>
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class CalendarIdListComposite extends Composite {

	// ログ
	private static Log m_log = LogFactory.getLog( CalendarIdListComposite.class );

	// ----- instance フィールド ----- //

	/** カレンダIDラベル */
	private Label labelCalendarId = null;

	/** カレンダIDコンボボックス */
	private Combo comboCalendarId = null;

	// ----- コンストラクタ ----- //

	/**
	 * インスタンスを返します。<BR>
	 * 
	 * @param parent 親のコンポジット
	 * @param style スタイル
	 * @param labelFlg カレンダIDラベル表示フラグ
	 */
	public CalendarIdListComposite(Composite parent, int style, boolean labelFlg) {
		super(parent, style);

		this.initialize(parent, labelFlg);
	}


	// ----- instance メソッド ----- //

	/**
	 * コンポジットを生成・構築します。<BR>
	 */
	private void initialize(Composite parent, boolean labelFlg) {

		// 変数として利用されるグリッドデータ
		GridData gridData = null;

		GridLayout layout = new GridLayout(1, true);
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		if(labelFlg){
			layout.numColumns = 15;
		}
		else{
			layout.numColumns = 10;
		}
		this.setLayout(layout);

		/*
		 * カレンダID
		 */
		if(labelFlg){
			// ラベル
			this.labelCalendarId = new Label(this, SWT.NONE);
			gridData = new GridData();
			gridData.horizontalSpan = CommonMonitorDialog.WIDTH_TITLE;
			gridData.horizontalAlignment = GridData.FILL;
			gridData.grabExcessHorizontalSpace = true;
			this.labelCalendarId.setLayoutData(gridData);
			this.labelCalendarId.setText(Messages.getString("calendar.id") + " : ");
		}

		// コンボボックス
		this.comboCalendarId = new Combo(this, SWT.DROP_DOWN | SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalSpan = 5;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		this.comboCalendarId.setLayoutData(gridData);

		this.update();
	}

	/**
	 * コンポジットを更新します。<BR>
	 * <p>
	 * 
	 */
	@Override
	public void update() {
	}

	/**
	 * オーダーロールIDが参照権限があるカレンダを選択するコンボボックスを生成します。
	 * 
	 * @param ownerRoleId オーダーロールID
	 */
	public void setOwnerRoleId(String ownerRoleId){

		// 初期化
		this.comboCalendarId.removeAll();

		// 空欄
		this.comboCalendarId.add("");

		List<String> list = null;
		// データ取得
		try {
			List<CalendarInfo> listTmp = null;
			list = new ArrayList<String>();
			if (ownerRoleId != null && !"".equals(ownerRoleId)) {
				listTmp = CalendarEndpointWrapper.getCalendarList(ownerRoleId);
				for (CalendarInfo info : listTmp) {
					list.add(info.getId());
				}
			}
		} catch (InvalidRole_Exception e) {
			// 権限なし
			MessageDialog.openInformation(null, Messages.getString("message"),
					Messages.getString("message.accesscontrol.16"));
			setEnabled(false);

		} catch (Exception e) {
			// 上記以外の例外
			m_log.warn("update(), " + e.getMessage(), e);
			MessageDialog.openError(
					null,
					Messages.getString("failed"),
					Messages.getString("message.hinemos.failure.unexpected") + ", " + e.getMessage());
		}

		if(list != null){
			// カレンダIDリスト
			for(String calendarId : list){
				this.comboCalendarId.add(calendarId);
			}
		}
	}

	/* (非 Javadoc)
	 * @see org.eclipse.swt.widgets.Control#setEnabled(boolean)
	 */
	@Override
	public void setEnabled(boolean enabled) {
		this.comboCalendarId.setEnabled(enabled);
	}

	/* (非 Javadoc)
	 * @see org.eclipse.swt.widgets.Control#getEnabled()
	 */
	@Override
	public boolean getEnabled() {
		return this.comboCalendarId.getEnabled();
	}

	/* (非 Javadoc)
	 * @see org.eclipse.swt.widgets.Combo#getText()
	 */
	public String getText() {
		return this.comboCalendarId.getText();
	}

	/* (非 Javadoc)
	 * @see org.eclipse.swt.widgets.Combo#setText(java.lang.String)
	 */
	public void setText(String string) {
		this.comboCalendarId.setText(string);
	}

	/* (非 Javadoc)
	 * コンボボックスにカレンダIDを追加する
	 */
	public void addText(String string) {
		this.comboCalendarId.add(string);
	}
}