/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.accesscontrol.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.accesscontrol.bean.RoleSettingTreeConstant;
import com.clustercontrol.accesscontrol.dialog.SystemPrivilegeDialog;
import com.clustercontrol.accesscontrol.view.RoleSettingTreeView;
import com.clustercontrol.accesscontrol.view.SystemPrivilegeListView;
import com.clustercontrol.ws.access.RoleInfo;
import com.clustercontrol.ws.accesscontrol.RoleTreeItem;

/**
 * アクセス権限[ロール設定]ビューの「システム権限の選択」のアクションクラス<BR>
 * 
 * @version 2.2.0
 * @since 2.0.0
 */
public class RoleSettingAssignSystemPrivilegeAction implements IViewActionDelegate {
	/** アクションID */
	public static final String ID = "com.clustercontrol.accesscontrol.view.action.RoleSettingAssignSystemPrivilegeAction";
	/** ビュー */
	private IViewPart viewPart;

	/**
	 * ビューを保持します。ワークベンチにロードされた際に呼ばれます。
	 * 
	 * @param view ビューのインスタンス
	 * 
	 * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
	 */
	@Override
	public void init(IViewPart viewPart) {
		this.viewPart = viewPart;
	}

	/**
	 * アクセス[ロール設定]ビューの「システム権限の選択」のアクション<BR>
	 * 
	 * アクセス[ロール設定]ビューの「システム権限の選択」が押された場合に、<BR>
	 * アクセス[システム権限の選択]ダイアログを表示し、ユーザを変更します。
	 * 
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 * @see com.clustercontrol.accesscontrol.dialog.UserDialog
	 * @see com.clustercontrol.accesscontrol.view.UserListView
	 */
	@Override
	public void run(IAction action) {
		// ロール設定より、選択されているロールのロールIDを取得

		RoleSettingTreeView roleSettingTreeView = (RoleSettingTreeView) this.viewPart
				.getAdapter(RoleSettingTreeView.class);

		StructuredSelection selection = (StructuredSelection) roleSettingTreeView
				.getTreeComposite().getTreeViewer().getSelection();

		RoleTreeItem item = (RoleTreeItem) selection.getFirstElement();
		Object data = item.getData();
		if (data instanceof RoleInfo
				&& !((RoleInfo)data).getId().equals(RoleSettingTreeConstant.ROOT_ID)) {
			SystemPrivilegeDialog dialog = new SystemPrivilegeDialog(
					PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(),
					((RoleInfo)data).getId());
			//ダイアログ表示
			if (dialog.open() == IDialogConstants.OK_ID) {
				roleSettingTreeView.update();

				//アクティブページを手に入れる
				IWorkbenchPage page = PlatformUI.getWorkbench()
						.getActiveWorkbenchWindow().getActivePage();

				//システム権限ビューを更新する
				IViewPart systemPrivilegeListView = page.findView(SystemPrivilegeListView.ID);
				if (systemPrivilegeListView != null) {
					SystemPrivilegeListView listView = (SystemPrivilegeListView) systemPrivilegeListView
							.getAdapter(SystemPrivilegeListView.class);
					listView.update();
				}
			}
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
	}
}