/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.accesscontrol.view.action;

import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.accesscontrol.action.GetRoleListTableDefine;
import com.clustercontrol.accesscontrol.dialog.RoleDialog;
import com.clustercontrol.accesscontrol.view.RoleListView;
import com.clustercontrol.accesscontrol.view.RoleSettingTreeView;

/**
 * アクセス[ロール]ビューの「変更」のアクションクラス<BR>
 * 
 * @version 2.2.0
 * @since 2.0.0
 */
public class RoleModifyAction implements IViewActionDelegate {
	/** アクションID */
	public static final String ID = "com.clustercontrol.accesscontrol.view.action.RoleModifyAction";
	/** ビュー */
	private IViewPart viewPart;

	/**
	 * ビューを保持します。ワークベンチにロードされた際に呼ばれます。
	 * 
	 * @param view ビューのインスタンス
	 * 
	 * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
	 */
	@Override
	public void init(IViewPart viewPart) {
		this.viewPart = viewPart;
	}

	/**
	 * アクセス[ロール]ビューの「変更」のアクション<BR>
	 * 
	 * アクセス[ロール]ビューの「変更」が押された場合に、<BR>
	 * アクセス[ロールの作成・変更]ダイアログを表示し、ユーザを変更します。
	 * <p>
	 * <ol>
	 * <li>アクセス[ロール]ビューから選択されているロールのロールIDを取得します。</li>
	 * <li>ロールIDが一致するロールのアクセス[ロールの作成・変更]ダイアログを表示します。</li>
	 * <li>アクセス[ロールの作成・変更]ダイアログからロール用プロパティを取得します。</li>
	 * <li>ロール用プロパティを元にロールを更新します。</li>
	 * <li>アクセス[ロール]ビューを更新します。</li>
	 * </ol>
	 * 
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 * @see com.clustercontrol.accesscontrol.dialog.UserDialog
	 * @see com.clustercontrol.accesscontrol.view.UserListView
	 */
	@Override
	public void run(IAction action) {
		// ロール一覧より、選択されているロールのロールIDを取得

		RoleListView roleListView = (RoleListView) this.viewPart
				.getAdapter(RoleListView.class);

		StructuredSelection selection = (StructuredSelection) roleListView
				.getComposite().getTableViewer().getSelection();

		List list = (List) selection.getFirstElement();
		String roleId = null;
		if (list != null) {
			roleId = (String) list.get(GetRoleListTableDefine.ROLE_ID);
		}

		if (roleId != null) {
			// ダイアログを生成
			RoleDialog dialog = new RoleDialog(this.viewPart
					.getSite().getShell(), roleId, true);

			// ダイアログにて変更が選択された場合、入力内容をもって更新を行う。
			if (dialog.open() == IDialogConstants.OK_ID) {
				roleListView.update();

				//アクティブページを手に入れる
				IWorkbenchPage page = PlatformUI.getWorkbench()
						.getActiveWorkbenchWindow().getActivePage();

				//ツリービューを更新する
				IViewPart roleTreeViewPart = page.findView(RoleSettingTreeView.ID);
				if (roleTreeViewPart != null) {
					RoleSettingTreeView treeView = (RoleSettingTreeView) roleTreeViewPart
							.getAdapter(RoleSettingTreeView.class);
					treeView.update();
				}
			}
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
	}
}