package com.clustercontrol.accesscontrol.ui;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;

import com.clustercontrol.ClusterControlPerspectiveBase;
import com.clustercontrol.accesscontrol.view.RoleListView;
import com.clustercontrol.accesscontrol.view.RoleSettingTreeView;
import com.clustercontrol.accesscontrol.view.SystemPrivilegeListView;
import com.clustercontrol.accesscontrol.view.UserListView;

/**
 * アカウントのパースペクティブを生成するクラスです。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class AccessManagementPerspective extends ClusterControlPerspectiveBase {

	/**
	 * 画面レイアウトを実装します。
	 * 
	 * @see org.eclipse.ui.IPerspectiveFactory#createInitialLayout(org.eclipse.ui.IPageLayout)
	 */
	@Override
	public void createInitialLayout(IPageLayout layout) {
		super.createInitialLayout(layout);

		//エディタ領域のIDを取得
		String editorArea = layout.getEditorArea();
		// エディタ領域の上部5割を占めるフォルダを作成
		layout.createFolder("top", IPageLayout.TOP, 0.5f, editorArea);
		// エディタ領域の下部5割を占めるフォルダを作成
		layout.createFolder("bottom", IPageLayout.BOTTOM, 0.5f, editorArea);
		// 上部5割のフォルダの左側を占めるフォルダを作成
		IFolderLayout topLeft = layout.createFolder("topLeft", IPageLayout.LEFT, 0.5f, "top");
		// 上部5割のフォルダの右側を占めるフォルダを作成
		IFolderLayout topRight = layout.createFolder("topRight", IPageLayout.RIGHT, 0.5f, "top");
		// 下部5割の左側半分を占めるフォルダを作成
		IFolderLayout bottomLeft = layout.createFolder("bottomLeft", IPageLayout.LEFT, 0.3f, "bottom");
		// 下部5割の右側半分を占めるフォルダを作成
		IFolderLayout bottomRight = layout.createFolder("bottomRight", IPageLayout.RIGHT, 0.7f, "bottom");
		// 各フォルダにビューを割り当てる
		bottomLeft.addView(RoleSettingTreeView.ID);
		bottomRight.addView(SystemPrivilegeListView.ID);
		topLeft.addView(RoleListView.ID);
		topRight.addView(UserListView.ID);
	}
}
