#!/bin/bash

echo ""
echo ""
echo "########################################################"
echo "### Gathering script of Agent Information (20110301) ###"
echo "###    Script started at `date '+%Y-%m-%d %T'`       ###"
echo "########################################################"
echo ""

function usage {
        echo "usage: "
        echo "$0 -vv  : Get information about OS INFORMATION"
        echo "$0 -vvv : Get information about DETAIL"
        return 0
}

function init {
## Hinemos Agent env
SCRIPT_DIR=$(cd $(dirname $0);pwd)
. ${SCRIPT_DIR}/../../conf/hinemos_agent.cfg
}

function os {
## cat /etc/redhat-release
echo "### cat /etc/redhat-release ###"
cat /etc/redhat-release
echo -e "\n"

## chkconfig --list | grep hinemos
echo "###  chkconfig --list | grep hinemos ###"
chkconfig --list | grep hinemos
echo -e "\n"

## rpm -qa
echo "### rpm -qa ###"
rpm -qa
echo -e "\n"

## cpuinfo
echo "### /proc/cpuinfo ###"
cat /proc/cpuinfo
echo -e ""

## meminfo
echo "### /proc/meminfo ###"
cat /proc/meminfo
echo -e "\n"

## sar -P ALL
echo "### sar -P ALL ###"
sar -P ALL
echo -e "\n"

## sar -r
echo "### sar -r ###"
sar -r
echo -e "\n"

## sar -n DEV
echo "### sar -n DEV ###"
sar -n DEV
echo -e "\n"

## sar -n EDEV
echo "### sar -n EDEV ###"
sar -n EDEV
echo -e "\n"

## vmstat -n
echo "### vmstat -n ###"
vmstat -n
echo -e "\n"

## iostat -d -x
echo "### iostat -d -x ###"
iostat -d -x
echo -e ""

## ps -H auxwww
echo "### ps -H auxwww ###"
ps -H auxwww
echo -e "\n"

## netstat -s
echo "### netstat -s ###"
netstat -s
echo -e "\n"

## netstat -anpo
echo "### netstat -anpo ###"
netstat -anpo
echo -e "\n"

## df
echo "### df ###"
df
echo -e "\n"

## df -i
echo "### df -i ###"
df -i
echo -e "\n"

## uptime
echo "### uptime ###"
uptime
echo -e "\n"

## /proc/slabinfo
echo "### /proc/slabinfo ###"
cat /proc/slabinfo
echo -e "\n"

## /proc/vmstat
echo "### /proc/vmstat ###"
cat /proc/vmstat
echo -e "\n"
}

function detail {
## lsof
echo "### lsof ###"
lsof
echo -e "\n"

## md5sum
echo "### md5sum ###"
cd ${HINEMOS_AGENT_HOME}
find `ls --ignore='var'` -type f | xargs md5sum
cd -
echo -e "\n"
}


if [ $# -eq 0 ]; then
        usage
        exit 1
fi

for OPTION in "$@"
do
        case $OPTION in
                -vv)
                        init
                        os
                        ;;
                -vvv)
                        init
                        os
                        detail
                        ;;
                *)
                        usage
                        exit 1
        esac
done

echo ""
echo "###################################################"
echo "###     Script ended at `date '+%Y-%m-%d %T'`     ###"
echo "###################################################"

exit 0
