package com.clustercontrol.collectiverun.model;

import java.io.Serializable;
import javax.persistence.*;

import com.clustercontrol.commons.util.JpaTransactionManager;

import java.util.List;


/**
 * The persistent class for the cc_crun_param_mst database table.
 * 
 */
@Entity
@Table(name="cc_crun_param_mst")
@Cacheable(true)
public class CrunParamMstEntity implements Serializable {
	private static final long serialVersionUID = 1L;
	private String paramId;
	private String nameId;
	private Integer paramType;
	private List<CrunCmdParamMstEntity> crunCmdParamMstEntities;
	private List<CrunParamSelectMstEntity> crunParamSelectMstEntities;

	@Deprecated
	public CrunParamMstEntity() {
	}


	public CrunParamMstEntity(String paramId) {
		this.setParamId(paramId);
		EntityManager em = new JpaTransactionManager().getEntityManager();
		em.persist(this);
	}


	@Id
	@Column(name="param_id")
	public String getParamId() {
		return this.paramId;
	}

	public void setParamId(String paramId) {
		this.paramId = paramId;
	}


	@Column(name="name_id")
	public String getNameId() {
		return this.nameId;
	}

	public void setNameId(String nameId) {
		this.nameId = nameId;
	}


	@Column(name="param_type")
	public Integer getParamType() {
		return this.paramType;
	}

	public void setParamType(Integer paramType) {
		this.paramType = paramType;
	}


	//bi-directional many-to-one association to CrunCmdParamMstEntity
	@OneToMany(mappedBy="crunParamMstEntity", cascade=CascadeType.ALL)
	public List<CrunCmdParamMstEntity> getCrunCmdParamMstEntities() {
		return this.crunCmdParamMstEntities;
	}

	public void setCrunCmdParamMstEntities(List<CrunCmdParamMstEntity> crunCmdParamMstEntities) {
		this.crunCmdParamMstEntities = crunCmdParamMstEntities;
	}


	//bi-directional many-to-one association to CrunParamSelectMstEntity
	@OneToMany(mappedBy="crunParamMstEntity", cascade=CascadeType.ALL)
	public List<CrunParamSelectMstEntity> getCrunParamSelectMstEntities() {
		return this.crunParamSelectMstEntities;
	}

	public void setCrunParamSelectMstEntities(List<CrunParamSelectMstEntity> crunParamSelectMstEntities) {
		this.crunParamSelectMstEntities = crunParamSelectMstEntities;
	}

}