#!/bin/bash

# Copyright (C) since 2006 NTT DATA Corporation
# 
# This program is free software; you can redistribute it and/or
# Modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation, version 2.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details

# bash configuration
SCRIPT_DIR=$(cd $(dirname $0);pwd)
. ${SCRIPT_DIR}/../hinemos.cfg
. ${SCRIPT_DIR}/../sbin/hinemos_utility.sh

export PROG=`basename $0`
DIR=`dirname $0`
USER=`/usr/bin/whoami`
HOST=`hostname`

########################################
#  Local Variable
########################################


########################################
#  Local Message
########################################

# INFO
MSG_I001="waiting for Hinemos Manager to stop..."
MSG_I002="Hinemos Manager stopped"

# WARN
#MSG_W001="xxx"

# ERROR
MSG_E001="failed to stop Hinemos Manager"

########################################
# Function
########################################

function usage {
	echo "usage : ${PROG} [-F]"
	echo "options:"
	echo "  -F   force startup without process dependency check"
}

########################################
# SHELL
########################################

# check argument
for OPT in $@
do
	case ${OPT} in
		--help)
			usage
			exit 0
			;;
	esac
done

# option check
OPT_FORCE=""
while getopts F OPT
do
	case ${OPT} in
		F)
			OPT_FORCE="-F"
			;;
		*)
			ExitIllegalOptionErrorWithoutLogger
			;;
	esac
done

shift $(( $OPTIND - 1 ))

if [ ! $# = 0 ]
then
	ExitIllegalArgumentError
fi

# check user executed
CheckUser ${JVM_USER}

Logging "${MSG_I001}"
echo

# shutdown JVM
${HINEMOS_HOME}/bin/jvm_stop.sh ${OPT_FORCE}

RET=$?
if [ ${RET} -ne 0 ]
then
	echo
	Logging "${MSG_E001}"
	exit ${RET}
fi

# shutdown PostgreSQL
echo
${HINEMOS_HOME}/bin/pg_stop.sh ${OPT_FORCE}

RET=$?
if [ ${RET} -ne 0 ]
then
	echo
	Logging "${MSG_E001}"
	exit ${RET}
fi

echo
Logging "${MSG_I002}"

exit 0
