/*

Copyright (C) 2011 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.util;

import com.clustercontrol.collectiverun.bean.CollectiveRunInfo;
import com.clustercontrol.commons.util.CommonValidator;
import com.clustercontrol.fault.InvalidSetting;
import com.clustercontrol.util.Messages;

/**
 * ユーザ管理の入力チェッククラス
 * 
 * @since 4.0
 * 
 */
public class CollectiveRunValidator {

	public static void validateCollectiveRunInfo(CollectiveRunInfo collectiveRunInfo) throws InvalidSetting{

		// facilityId
		CommonValidator.validateId(Messages.getString("facility.id"), collectiveRunInfo.getFacilityId(), 64);
	}
}
