/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.security.rules;

import java.beans.Introspector;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jpasecurity.AccessType;
import net.sf.jpasecurity.jpql.compiler.QueryPreparator;
import net.sf.jpasecurity.jpql.parser.JpqlFromItem;
import net.sf.jpasecurity.jpql.parser.JpqlInnerJoin;
import net.sf.jpasecurity.jpql.parser.JpqlOuterJoin;
import net.sf.jpasecurity.jpql.parser.JpqlParser;
import net.sf.jpasecurity.jpql.parser.JpqlPath;
import net.sf.jpasecurity.jpql.parser.JpqlSelectExpressions;
import net.sf.jpasecurity.jpql.parser.JpqlSubselect;
import net.sf.jpasecurity.jpql.parser.JpqlVisitorAdapter;
import net.sf.jpasecurity.jpql.parser.JpqlWhere;
import net.sf.jpasecurity.jpql.parser.Node;
import net.sf.jpasecurity.jpql.parser.ParseException;
import net.sf.jpasecurity.mapping.Alias;
import net.sf.jpasecurity.security.Permit;
import net.sf.jpasecurity.security.rules.AbstractAccessRulesProvider;
import net.sf.jpasecurity.security.rules.PermissionParser;
import net.sf.jpasecurity.security.rules.RolesAllowedParser;
import net.sf.jpasecurity.util.ListMap;
import net.sf.jpasecurity.util.SetMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationAccessRulesProvider
extends AbstractAccessRulesProvider {
    private static final Alias THIS_ALIAS = new Alias("this");
    private final RolesAllowedParser rolesAllowedParser = new RolesAllowedParser();
    private final PermissionParser permissionParser = new PermissionParser();
    private final JpqlParser whereClauseParser = new JpqlParser();
    private final AliasVisitor aliasVisitor = new AliasVisitor();

    @Override
    protected void initializeAccessRules() {
        HashSet<String> rules = new HashSet<String>();
        for (Class<?> annotatedClass : this.getPersistenceMapping().getSecureClasses()) {
            rules.addAll(this.parseAllowedRoles(annotatedClass));
            rules.addAll(this.parsePermissions(annotatedClass));
        }
        rules.remove(null);
        this.compileRules(rules);
    }

    Collection<String> parseAllowedRoles(Class<?> annotatedClass) {
        SetMap<Set<AccessType>, String> accessTypes = this.rolesAllowedParser.parseAllowedRoles(annotatedClass);
        HashSet<String> rules = new HashSet<String>();
        for (Map.Entry roles : accessTypes.entrySet()) {
            String name = annotatedClass.getSimpleName();
            StringBuilder rule = new StringBuilder("GRANT ");
            if (((Set)roles.getKey()).contains((Object)AccessType.CREATE)) {
                rule.append("CREATE ");
            }
            if (((Set)roles.getKey()).contains((Object)AccessType.READ)) {
                rule.append("READ ");
            }
            if (((Set)roles.getKey()).contains((Object)AccessType.UPDATE)) {
                rule.append("UPDATE ");
            }
            if (((Set)roles.getKey()).contains((Object)AccessType.DELETE)) {
                rule.append("DELETE ");
            }
            rule.append("ACCESS TO ");
            rule.append(annotatedClass.getName()).append(' ');
            rule.append(Character.toLowerCase(name.charAt(0))).append(name.substring(1)).append(' ');
            Iterator roleIterator = ((Set)roles.getValue()).iterator();
            rule.append("WHERE '").append((String)roleIterator.next()).append("' IN (CURRENT_ROLES)");
            if (roleIterator.hasNext()) {
                String role = (String)roleIterator.next();
                while (roleIterator.hasNext()) {
                    rule.append(" OR '").append(role).append("' IN (CURRENT_ROLES)");
                    role = (String)roleIterator.next();
                }
            }
            rules.add(rule.toString());
        }
        return rules;
    }

    Collection<String> parsePermissions(Class<?> annotatedClass) {
        try {
            HashSet<String> rules = new HashSet<String>();
            ListMap<Class<?>, Permit> permissions = this.permissionParser.parsePermissions(annotatedClass);
            for (Map.Entry annotations : permissions.entrySet()) {
                String name = annotatedClass.getSimpleName();
                for (Permit permission : (List)annotations.getValue()) {
                    Alias alias = new Alias(Introspector.decapitalize(name));
                    JpqlWhere whereClause = null;
                    if (permission.rule().trim().length() > 0) {
                        whereClause = this.whereClauseParser.parseWhereClause("WHERE " + permission.rule());
                        alias = this.findUnusedAlias(whereClause, alias);
                        this.appendAlias(whereClause, alias);
                    }
                    StringBuilder rule = new StringBuilder("GRANT ");
                    List<AccessType> access = Arrays.asList(permission.access());
                    if (access.contains((Object)AccessType.CREATE)) {
                        rule.append("CREATE ");
                    }
                    if (access.contains((Object)AccessType.READ)) {
                        rule.append("READ ");
                    }
                    if (access.contains((Object)AccessType.UPDATE)) {
                        rule.append("UPDATE ");
                    }
                    if (access.contains((Object)AccessType.DELETE)) {
                        rule.append("DELETE ");
                    }
                    rule.append("ACCESS TO ");
                    rule.append(annotatedClass.getName()).append(' ');
                    rule.append(alias);
                    if (whereClause != null) {
                        rule.append(' ').append(whereClause);
                    }
                    rules.add(rule.toString());
                }
            }
            return rules;
        }
        catch (ParseException e) {
            throw this.getConfiguration().getExceptionFactory().createRuntimeException(e);
        }
    }

    private Alias findUnusedAlias(JpqlWhere whereClause, Alias alias) {
        HashSet declaredAliases = new HashSet();
        whereClause.visit(this.aliasVisitor, declaredAliases);
        int i = 0;
        while (declaredAliases.contains(alias)) {
            alias = new Alias(alias.getName() + i);
            ++i;
        }
        return alias;
    }

    private void appendAlias(JpqlWhere whereClause, Alias alias) {
        PathVisitor pathVisitor = new PathVisitor(alias);
        whereClause.visit(pathVisitor, new HashSet());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PathVisitor
    extends JpqlVisitorAdapter<Set<Alias>> {
        private final Alias alias;
        private final QueryPreparator queryPreparator = new QueryPreparator();

        public PathVisitor(Alias alias) {
            this.alias = alias;
        }

        @Override
        public boolean visit(JpqlSubselect select, Set<Alias> declaredAliases) {
            HashSet<Alias> subselectAliases = new HashSet<Alias>(declaredAliases);
            select.visit(AnnotationAccessRulesProvider.this.aliasVisitor, subselectAliases);
            for (int i = 0; i < select.jjtGetNumChildren(); ++i) {
                select.jjtGetChild(i).visit(this, subselectAliases);
            }
            return false;
        }

        @Override
        public boolean visit(JpqlPath path, Set<Alias> declaredAliases) {
            Alias a = new Alias(path.jjtGetChild(0).getValue().toLowerCase());
            if (THIS_ALIAS.equals(a)) {
                this.queryPreparator.replace(path.jjtGetChild(0), this.queryPreparator.createIdentifier(this.alias.getName()));
            } else if (!(declaredAliases.contains(a) || path.jjtGetNumChildren() <= 1 && AnnotationAccessRulesProvider.this.getSecurityContext().getAliases().contains(a))) {
                this.queryPreparator.prepend(this.alias, path);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AliasVisitor
    extends JpqlVisitorAdapter<Set<Alias>> {
        private AliasVisitor() {
        }

        @Override
        public boolean visit(JpqlSelectExpressions select) {
            return false;
        }

        @Override
        public boolean visit(JpqlFromItem from, Set<Alias> declaredAliases) {
            return this.visitAlias(from, declaredAliases);
        }

        @Override
        public boolean visit(JpqlInnerJoin join, Set<Alias> declaredAliases) {
            return this.visitAlias(join, declaredAliases);
        }

        @Override
        public boolean visit(JpqlOuterJoin join, Set<Alias> declaredAliases) {
            return this.visitAlias(join, declaredAliases);
        }

        public boolean visitAlias(Node node, Set<Alias> declaredAliases) {
            if (node.jjtGetNumChildren() == 2) {
                declaredAliases.add(new Alias(node.jjtGetChild(1).getValue().toLowerCase()));
            }
            return false;
        }
    }
}

