/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.security.authentication;

import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import net.sf.jpasecurity.configuration.AuthenticationProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticAuthenticationProvider
implements AuthenticationProvider {
    private static Object principal;
    private static Collection<?> roles;

    public static void authenticate(Object principal, Object ... roles) {
        StaticAuthenticationProvider.authenticate(principal, Arrays.asList(roles));
    }

    public static void authenticate(Object principal, Collection<?> roles) {
        if (roles == null) {
            roles = Collections.emptySet();
        }
        StaticAuthenticationProvider.principal = principal;
        StaticAuthenticationProvider.roles = roles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R runAs(Object principal, Collection<?> roles, PrivilegedExceptionAction<R> action) throws Exception {
        Object currentPrincipal = StaticAuthenticationProvider.principal;
        Collection<?> currentRoles = StaticAuthenticationProvider.roles;
        try {
            StaticAuthenticationProvider.authenticate(principal, roles);
            R r = action.run();
            return r;
        }
        finally {
            StaticAuthenticationProvider.authenticate(currentPrincipal, currentRoles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R runAs(Object principal, Collection<?> roles, PrivilegedAction<R> action) {
        Object currentUser = StaticAuthenticationProvider.principal;
        Collection<?> currentRoles = StaticAuthenticationProvider.roles;
        try {
            StaticAuthenticationProvider.authenticate(principal, roles);
            R r = action.run();
            return r;
        }
        finally {
            StaticAuthenticationProvider.authenticate(currentUser, currentRoles);
        }
    }

    @Override
    public Object getPrincipal() {
        return principal;
    }

    public Collection<?> getRoles() {
        return Collections.unmodifiableCollection(roles);
    }

    static {
        roles = Collections.emptySet();
    }
}

