/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.security;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.jpasecurity.configuration.SecurityContext;
import net.sf.jpasecurity.mapping.Alias;
import net.sf.jpasecurity.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanSecurityContext
implements SecurityContext {
    private Object bean;
    private Map<Alias, Method> readMethods;

    public BeanSecurityContext(Object bean) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            HashMap<Alias, Method> readMethods = new HashMap<Alias, Method>();
            for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                readMethods.put(new Alias(propertyDescriptor.getName()), propertyDescriptor.getReadMethod());
            }
            this.bean = bean;
            this.readMethods = Collections.unmodifiableMap(readMethods);
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Collection<Alias> getAliases() {
        return this.readMethods.keySet();
    }

    @Override
    public Object getAliasValue(Alias alias) {
        return ReflectionUtils.invokeMethod(this.bean, this.readMethods.get(alias), new Object[0]);
    }

    public Collection<?> getAliasValues(Alias alias) {
        Object aliasValue = this.getAliasValue(alias);
        if (aliasValue instanceof Collection) {
            return (Collection)aliasValue;
        }
        if (aliasValue == null) {
            return null;
        }
        if (aliasValue.getClass().isArray()) {
            return Arrays.asList((Object[])aliasValue);
        }
        return Collections.singleton(aliasValue);
    }
}

