/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.proxy;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jpasecurity.SecureEntity;

public class SecureEntityMethods {
    private static final Map<String, List<Class<?>>> ENTRIES;

    public static boolean contains(Method method) {
        List<Class<?>> secureEntityMethodParameterTypes = ENTRIES.get(method.getName());
        if (secureEntityMethodParameterTypes == null) {
            return false;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (secureEntityMethodParameterTypes.size() != parameterTypes.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (secureEntityMethodParameterTypes.get(i) == parameterTypes[i]) continue;
            return false;
        }
        return true;
    }

    static {
        HashMap<String, List<Object>> secureEntityMethods = new HashMap<String, List<Object>>();
        for (Method method : SecureEntity.class.getMethods()) {
            if (secureEntityMethods.containsKey(method.getName())) {
                String message = SecureEntity.class.getName() + " must have more than one method with name " + method.getName();
                throw new IllegalStateException(message);
            }
            if (method.getParameterTypes().length == 0) {
                secureEntityMethods.put(method.getName(), Collections.emptyList());
                continue;
            }
            List<Class<?>> parameterTypes = Arrays.asList(method.getParameterTypes());
            secureEntityMethods.put(method.getName(), Collections.unmodifiableList(parameterTypes));
        }
        ENTRIES = Collections.unmodifiableMap(secureEntityMethods);
    }
}

