/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.mapping;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import net.sf.jpasecurity.mapping.BeanInitializer;
import net.sf.jpasecurity.mapping.ClassMappingInformation;
import net.sf.jpasecurity.mapping.DefaultPropertyAccessStrategyFactory;
import net.sf.jpasecurity.mapping.PropertyAccessStrategy;
import net.sf.jpasecurity.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavassistPropertyAccessStrategyFactory
extends DefaultPropertyAccessStrategyFactory {
    public JavassistPropertyAccessStrategyFactory() {
    }

    public JavassistPropertyAccessStrategyFactory(BeanInitializer beanInitializer) {
        super(beanInitializer);
    }

    @Override
    public PropertyAccessStrategy createPropertyAccessStrategy(ClassMappingInformation classMapping, String propertyName) {
        AccessibleObject writeMember;
        AccessibleObject readMember;
        Class entityType = classMapping.getEntityType();
        String className = entityType.getName();
        boolean usesFieldAccess = classMapping.usesFieldAccess();
        if (usesFieldAccess) {
            writeMember = readMember = this.getField(entityType, propertyName);
        } else {
            readMember = this.getReadMethod(entityType, propertyName);
            writeMember = this.getWriteMethod(entityType, propertyName);
        }
        if (!this.isAccessible((Member)((Object)readMember)) || !this.isAccessible((Member)((Object)writeMember))) {
            return super.createPropertyAccessStrategy(classMapping, propertyName);
        }
        PropertyAccessStrategy propertyAccessStrategy = this.findPropertyAccessStrategy(className, propertyName);
        if (propertyAccessStrategy != null) {
            return propertyAccessStrategy;
        }
        return this.createPropertyAccessStrategy(className, propertyName, (Member)((Object)readMember), (Member)((Object)writeMember), usesFieldAccess);
    }

    private boolean isAccessible(Member member) {
        return !Modifier.isPrivate(member.getModifiers());
    }

    private String getPropertyAccessStrategyClassName(String className, String propertyName) {
        return className + this.capitalize(propertyName) + "PropertyAccessStrategy";
    }

    private PropertyAccessStrategy findPropertyAccessStrategy(String className, String propertyName) {
        try {
            String propertyAccessStrategyClassName = this.getPropertyAccessStrategyClassName(className, propertyName);
            Class<?> propertyAccessStrategyClass = Class.forName(propertyAccessStrategyClassName);
            return (PropertyAccessStrategy)ReflectionUtils.newInstance(propertyAccessStrategyClass, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private PropertyAccessStrategy createPropertyAccessStrategy(String className, String propertyName, Member readMember, Member writeMember, boolean usesFieldAccess) {
        return ReflectionUtils.newInstance(this.createPropertyAccessStrategyClass(className, propertyName, readMember, writeMember, usesFieldAccess), new Object[0]);
    }

    private Class<PropertyAccessStrategy> createPropertyAccessStrategyClass(String className, String propertyName, Member readMember, Member writeMember, boolean usesFieldAccess) {
        try {
            String propertyAccessStrategyClassName = this.getPropertyAccessStrategyClassName(className, propertyName);
            ClassPool pool = ClassPool.getDefault();
            CtClass strategy = pool.makeClass(propertyAccessStrategyClassName);
            strategy.setInterfaces(new CtClass[]{pool.get(PropertyAccessStrategy.class.getName())});
            strategy.addConstructor(CtNewConstructor.defaultConstructor((CtClass)strategy));
            CtMethod readMethod = CtNewMethod.make((String)this.getReadMethod(className, readMember, usesFieldAccess), (CtClass)strategy);
            strategy.addMethod(readMethod);
            CtMethod writeMethod = CtNewMethod.make((String)this.getWriteMethod(className, writeMember, usesFieldAccess), (CtClass)strategy);
            strategy.addMethod(writeMethod);
            return strategy.toClass();
        }
        catch (NotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (CannotCompileException e) {
            throw new IllegalStateException(e);
        }
    }

    private String getReadMethod(String className, Member readMember, boolean usesFieldAccess) {
        return "public Object getPropertyValue(Object target) {    return ($w)((" + className + ")$1)." + readMember.getName() + (usesFieldAccess ? ";" : "();") + "}";
    }

    private String getWriteMethod(String className, Member writeMember, boolean usesFieldAccess) {
        Class<?> propertyType = this.getPropertyType(writeMember, usesFieldAccess);
        return "public void setPropertyValue(Object target, Object value) {    ((" + className + ")$1)." + writeMember.getName() + (usesFieldAccess ? " = " : "") + "(" + this.getCastExpression(propertyType) + ");" + "}";
    }

    private Class<?> getPropertyType(Member writeMember, boolean usesFieldAccess) {
        return usesFieldAccess ? ((Field)writeMember).getType() : ((Method)writeMember).getParameterTypes()[0];
    }

    private String getCastExpression(Class<?> propertyType) {
        if (propertyType.equals(Boolean.TYPE)) {
            return "((Boolean)$2).booleanValue()";
        }
        if (propertyType.equals(Byte.TYPE)) {
            return "((Byte)$2).byteValue()";
        }
        if (propertyType.equals(Character.TYPE)) {
            return "((Character)$2).charValue()";
        }
        if (propertyType.equals(Short.TYPE)) {
            return "((Short)$2).shortValue()";
        }
        if (propertyType.equals(Integer.TYPE)) {
            return "((Integer)$2).intValue()";
        }
        if (propertyType.equals(Long.TYPE)) {
            return "((Long)$2).longValue()";
        }
        if (propertyType.equals(Float.TYPE)) {
            return "((Float)$2).floatValue()";
        }
        if (propertyType.equals(Double.TYPE)) {
            return "((Double)$2).doubleValue()";
        }
        return "(" + propertyType.getName() + ")$2";
    }
}

