/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.jpql.compiler;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.sf.jpasecurity.jpql.compiler.NotEvaluatableException;
import net.sf.jpasecurity.mapping.Alias;
import net.sf.jpasecurity.mapping.MappingInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryEvaluationParameters {
    private static final Object UNDEFINED = new Object();
    private final MappingInformation mappingInformation;
    private final Map<Alias, Object> aliases;
    private final Map<String, Object> namedParameters;
    private final Map<Integer, Object> positionalParameters;
    private final boolean inMemory;
    private Object result = UNDEFINED;

    public QueryEvaluationParameters(MappingInformation mappingInformation, Map<Alias, Object> aliases, Map<String, Object> namedParameters, Map<Integer, Object> positionalParameters) {
        this(mappingInformation, aliases, namedParameters, positionalParameters, false);
    }

    public QueryEvaluationParameters(MappingInformation mappingInformation, Map<Alias, Object> aliases, Map<String, Object> namedParameters, Map<Integer, Object> positionalParameters, boolean inMemory) {
        if (mappingInformation == null) {
            throw new IllegalArgumentException("mappingInformation may not be null");
        }
        this.mappingInformation = mappingInformation;
        this.aliases = aliases;
        this.namedParameters = namedParameters;
        this.positionalParameters = positionalParameters;
        this.inMemory = inMemory;
    }

    public QueryEvaluationParameters(QueryEvaluationParameters parameters) {
        this(parameters.mappingInformation, parameters.aliases, parameters.namedParameters, parameters.positionalParameters, parameters.inMemory);
    }

    public MappingInformation getMappingInformation() {
        return this.mappingInformation;
    }

    public boolean isInMemory() {
        return this.inMemory;
    }

    public Set<Alias> getAliases() {
        return this.aliases.keySet();
    }

    public Map<Alias, Object> getAliasValues() {
        return Collections.unmodifiableMap(this.aliases);
    }

    public Object getAliasValue(Alias alias) throws NotEvaluatableException {
        if (!this.aliases.containsKey(alias)) {
            throw new NotEvaluatableException("alias '" + alias + "' not defined");
        }
        return this.aliases.get(alias);
    }

    public Map<String, Object> getNamedParameters() {
        return Collections.unmodifiableMap(this.namedParameters);
    }

    public Object getNamedParameterValue(String namedParameter) throws NotEvaluatableException {
        if (!this.namedParameters.containsKey(namedParameter)) {
            throw new NotEvaluatableException();
        }
        return this.namedParameters.get(namedParameter);
    }

    public Map<Integer, Object> getPositionalParameters() {
        return Collections.unmodifiableMap(this.positionalParameters);
    }

    public Object getPositionalParameterValue(int index) throws NotEvaluatableException {
        if (!this.positionalParameters.containsKey(index)) {
            throw new NotEvaluatableException();
        }
        return this.positionalParameters.get(index);
    }

    public boolean isResultUndefined() {
        return this.result == UNDEFINED;
    }

    public <T> T getResult() throws NotEvaluatableException {
        if (this.isResultUndefined()) {
            throw new NotEvaluatableException();
        }
        return (T)this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public void setResultUndefined() {
        this.result = UNDEFINED;
    }
}

