/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ResultSetRecord;

public class SimpleResultSetRecord
extends ResultSetRecord {
    protected transient boolean shouldKeepValues;
    protected transient boolean shouldUseOptimization;
    protected transient boolean isPopulatingObject;

    protected SimpleResultSetRecord() {
    }

    public SimpleResultSetRecord(Vector fields, DatabaseField[] fieldsArray, ResultSet resultSet, ResultSetMetaData metaData, DatabaseAccessor accessor, AbstractSession session) {
        super(fields, fieldsArray, resultSet, metaData, accessor, session);
    }

    @Override
    protected Object getValue(int index, DatabaseField field) {
        Object value = this.valuesArray[index];
        if (value != null) {
            if (!this.isPopulatingObject) {
                this.isPopulatingObject = true;
            }
            if (!this.shouldKeepValues) {
                this.valuesArray[index] = null;
            }
        } else {
            value = this.getValueFromResultSet(index, field);
            if (!this.isPopulatingObject || this.shouldKeepValues) {
                this.valuesArray[index] = value;
            }
        }
        return value;
    }

    @Override
    protected Object getValueFromResultSet(int index, DatabaseField field) {
        if (this.shouldUseOptimization) {
            try {
                Class fieldType = field.getType();
                if (fieldType == ClassConstants.STRING) {
                    return this.resultSet.getString(index + 1);
                }
                if (fieldType == ClassConstants.LONG) {
                    return this.resultSet.getLong(index + 1);
                }
                if (fieldType == ClassConstants.INTEGER) {
                    return this.resultSet.getInt(index + 1);
                }
            }
            catch (SQLException exception) {
                DatabaseException commException = this.accessor.processExceptionForCommError(this.session, exception, null);
                if (commException != null) {
                    throw commException;
                }
                throw DatabaseException.sqlException(exception, this.accessor, this.session, false);
            }
        }
        return super.getValueFromResultSet(index, field);
    }

    public void reset() {
        block3: {
            block2: {
                if (!this.isPopulatingObject) break block2;
                this.isPopulatingObject = false;
                if (!this.shouldKeepValues) break block3;
                int index = 0;
                while (index < this.valuesArray.length) {
                    this.valuesArray[index] = null;
                    ++index;
                }
                break block3;
            }
            int index = 0;
            while (index < this.valuesArray.length) {
                this.valuesArray[index] = null;
                ++index;
            }
        }
    }

    public boolean shouldKeepValues() {
        return this.shouldKeepValues;
    }

    public void setShouldKeepValues(boolean shouldKeepValues) {
        this.shouldKeepValues = shouldKeepValues;
    }

    public boolean shouldUseOptimization() {
        return this.shouldUseOptimization;
    }

    public void setShouldUseOptimization(boolean shouldUseOptimization) {
        this.shouldUseOptimization = shouldUseOptimization;
    }

    public boolean hasValues() {
        return this.valuesArray[0] != null;
    }

    public boolean isPopulatingObject() {
        return this.isPopulatingObject;
    }
}

