/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.util;

import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.IResourceManagement.IEndpoint;
import com.clustercontrol.cloud.bean.CloudRegion;

public class ResourceRegion implements IResourceManagement.IRegion {
	private CloudRegion cloudRegion;

	public ResourceRegion(CloudRegion cloudRegion) {
		this.cloudRegion = cloudRegion;
	}
	
	@Override
	public String getName() {
		return cloudRegion.getRegion();
	}

	@Override
	public IEndpoint getEndpoint(final String type) {
		final String location = cloudRegion.getEndpoint(type).getLocation();
		if (location != null) {
			return new IEndpoint() {
				@Override
				public String getEndpointType() {
					return type;
				}
				@Override
				public String getLocation() {
					return location;
				}
			};
		}
		else {
			throw new InternalManagerError();
		}
	}
}
