/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.bean;

import java.util.ArrayList;
import java.util.List;

import com.clustercontrol.cloud.validation.annotation.ElementId;
import com.clustercontrol.cloud.validation.annotation.Into;
import com.clustercontrol.cloud.validation.annotation.NotNull;

/**
 * インスタンス作成要求に必要な情報を保持するクラス。 
 * {@link com.clustercontrol.ws.cloud.CloudEndpoint#addInstance(String,String,CreateInstanceRequest request) addInstance 関数} にて使用される。
 *
 */
public class CreateInstanceRequest extends CloudRequest {
	private NodeDetail nodeDetail;

	private String flavor;
	private String imageId;
	private String zone;
	private String instanceDetail;
	private List<Tag> tags = new ArrayList<Tag>();


	public CreateInstanceRequest() {
	}	

	/**
	 * ノード作成に必要な情報を返す。
	 * 
	 * @return ノード作成情報。
	 */
	@ElementId("NodeDetail")
	@NotNull
	@Into
	public NodeDetail getNodeDetail() {
		return nodeDetail;
	}

	/**
	 * ノード作成情報を指定する。
	 * この値は、{@link com.clustercontrol.ws.cloud.CloudEndpoint#addInstance(String,String,CreateInstanceRequest) addInstance 関数} を実行する際、必須となります。
	 * 
	 * @param nodeDetail ノード作成情報。
	 */
	public void setNodeDetail(NodeDetail nodeDetail) {
		this.nodeDetail = nodeDetail;
	}

	/**
	 * クラウド側へ指定するインスタンスの種別を取得する。
	 * 
	 * @return クラウド側へ指定するインスタンスの種別。
	 */
	public String getFlavor() {
		return flavor;
	}
	/**
	 * クラウド側へ指定するインスタンスの種別を設定する。
	 * 
	 * @param flavor クラウド側へ指定するインスタンスの種別
	 */
	public void setFlavor(String flavor) {
		this.flavor = flavor;
	}
	
	/**
	 * EC2 インスタンスに適用するイメージ ID を取得する。
	 * 
	 * @return AMI ID
	 */
	@ElementId("imageId")
	@NotNull
	public String getImageId() {
		return imageId;
	}

	/**
	 * EC2 インスタンスに適用するイメージ ID を指定する。
	 * この値は、128 文字以内となります。
	 * 
	 * @param imageId AMI ID
	 */
	public void setImageId(String imageId) {
		this.imageId = imageId;
	}

	/**
	 * インスタンスを配置するゾーンを取得する。
	 * 
	 * @return インスタンスを配置するゾーン。
	 */
	public String getZone() {
		return zone;
	}
	/**
	 * インスタンスを配置するゾーンを設定する。
	 * 
	 * @param zone インスタンスを配置するゾーン。
	 */
	public void setZone(String zone) {
		this.zone = zone;
	}

	/**
	 * インスタンス作成に際し必要なクラウド固有の情報を取得する。
	 * 
	 * @return インスタンス作成に際し必要なクラウド固有の情報。
	 */
	public String getInstanceDetail() {
		return instanceDetail;
	}
	/**
	 * インスタンス作成に際し必要なクラウド固有の情報を設定する。
	 * 
	 * @param instanceDetail インスタンス作成に際し必要なクラウド固有の情報。
	 */
	public void setInstanceDetail(String instanceDetail) {
		this.instanceDetail = instanceDetail;
	}

	/**
	 * インスタンスへ設定するタグの一覧を取得する。
	 * 
	 * @return インスタンスへ設定するタグの一覧。
	 */
	@ElementId("tags")
	@NotNull
	public List<Tag> getTags() {
		return tags;
	}
	/**
	 * インスタンスへ設定するタグの一覧を設定する。
	 * 
	 * @param tags インスタンスへ設定するタグの一覧。
	 */
	public void setTags(List<Tag> tags) {
		this.tags = tags;
	}
}