/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.ws.azure;

import java.util.List;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.IResourceManagement.Instance;
import com.clustercontrol.cloud.azure.bean.AzureCreateInstanceRequest;
import com.clustercontrol.cloud.azure.bean.AzureCreateStorageRequest;
import com.clustercontrol.cloud.azure.bean.AzureImage;
import com.clustercontrol.cloud.azure.bean.AzureRestoreStorageRequest;
import com.clustercontrol.cloud.azure.bean.SnapShotInfo;
import com.clustercontrol.cloud.bean.CloudStorage;
import com.clustercontrol.cloud.validation.annotation.ElementId;
import com.clustercontrol.cloud.validation.annotation.Identity;
import com.clustercontrol.cloud.validation.annotation.NotNull;
import com.clustercontrol.fault.InvalidRole;
import com.clustercontrol.fault.InvalidUserPass;

/**
 * クラウド管理オプションの Web サービス API 定義。
 *
 *
 */
@WebService(targetNamespace = "http://azure.ws.clustercontrol.com")
public interface AzureOptionEndpoint {

	@WebMethod
	List<InstanceInfo> getInstanceByCloudService(@WebParam(name = "roleId") String roleId, @WebParam(name = "region") String region, @WebParam(name="cloudServiceName") String cloudServiceName) throws CloudManagerFault, InvalidUserPass, InvalidRole;

	@WebMethod
	List<String> getStorageAccountByRegion(@WebParam(name = "roleId") String roleId, @WebParam(name = "region") String region) throws CloudManagerFault, InvalidUserPass, InvalidRole;

	@WebMethod
	String getRegionByCloudService(@WebParam(name = "roleId") String roleId, @WebParam(name = "region") String region, @WebParam(name="cloudServiceName") String cloudServiceName) throws CloudManagerFault, InvalidUserPass, InvalidRole;

	@WebMethod
	List<String> getStorageAccountByCloudService(@WebParam(name = "roleId") String roleId, @WebParam(name = "region") String region, @WebParam(name="cloudServiceName") String cloudServiceName) throws CloudManagerFault, InvalidUserPass, InvalidRole;

	@WebMethod
	List<DataVirtualHardDisks> getAttacheableDataVirtualHardDisk(@ElementId("roleId") @Identity String roleId,@WebParam(name = "region") String region,@ElementId("instanceId") @NotNull String instanceId) throws CloudManagerFault, InvalidUserPass, InvalidRole;

	void detachStorage(@ElementId("roleId") @Identity String roleId,@WebParam(name = "region") String region,@ElementId("instanceId") @NotNull String instanceId, @ElementId("storageId") @NotNull String storageId) throws CloudManagerFault, InvalidUserPass, InvalidRole;
	
	void atachStorage(@ElementId("roleId") @Identity String roleId,@ElementId("region") @NotNull String region, @WebParam(name = "storageId") String storageId, @WebParam(name="AzureCreateStorageRequest") AzureCreateStorageRequest request) throws CloudManagerFault, InvalidUserPass, InvalidRole;
	
	@WebMethod
	List<String> getContainerByStorageAccount(@WebParam(name = "roleId") String roleId, @WebParam(name = "region") String region, @WebParam(name="storageAccountName") String storageAccountName) throws CloudManagerFault, InvalidUserPass, InvalidRole;

	@WebMethod
	CloudStorage addStorage(@WebParam(name = "roleId") String roleId, @WebParam(name = "region") String region, @WebParam(name="request") AzureCreateStorageRequest request) throws CloudManagerFault, InvalidUserPass, InvalidRole;

	@WebMethod
	Instance createInstance(@WebParam(name = "roleId") String roleId, @WebParam(name = "region") String region, @WebParam(name="request") AzureCreateInstanceRequest request) throws CloudManagerFault, InvalidUserPass, InvalidRole;

	@WebMethod
	List<AzureImage> getImagesWithFilter(@WebParam(name = "roleId") String roleId, @WebParam(name = "region") String region, @WebParam(name="filter") String filter) throws CloudManagerFault, InvalidUserPass, InvalidRole;
	
	@WebMethod
	SnapShotInfo getSnapShotInfo(@WebParam(name = "roleId") String roleId, @WebParam(name = "region") String region, @WebParam(name="snapShotId") String snapShotId, @WebParam(name="storageId") String storageId) throws CloudManagerFault, InvalidUserPass, InvalidRole;
	
	@WebMethod
	CloudStorage restoreStorage(@WebParam(name = "roleId") String roleId, @WebParam(name = "region") String region, @WebParam(name="AzureRestoreStorageRequest") AzureRestoreStorageRequest request) throws CloudManagerFault, InvalidUserPass, InvalidRole;
	
	@WebMethod
	void deleteStorageBackup(@WebParam(name = "storageBackupURL") String storageBackupURL) throws CloudManagerFault;

}