package com.clustercontrol.cloud.azure.factory;

import org.apache.log4j.Logger;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.azure.util.AzureUtil;
import com.microsoft.windowsazure.Configuration;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.AffinityGroupOperations;
import com.microsoft.windowsazure.management.ManagementClient;
import com.microsoft.windowsazure.management.ManagementService;
import com.microsoft.windowsazure.management.compute.ComputeManagementClient;
import com.microsoft.windowsazure.management.compute.ComputeManagementService;
import com.microsoft.windowsazure.management.compute.DeploymentOperations;
import com.microsoft.windowsazure.management.compute.VirtualMachineDiskOperations;
import com.microsoft.windowsazure.management.compute.models.DataVirtualHardDisk;
import com.microsoft.windowsazure.management.compute.models.DeploymentGetResponse;
import com.microsoft.windowsazure.management.compute.models.DeploymentSlot;
import com.microsoft.windowsazure.management.compute.models.Role;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineDiskListResponse;
import com.microsoft.windowsazure.management.compute.models.HostedServiceListResponse.HostedService;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineDiskListResponse.VirtualMachineDisk;
import com.microsoft.windowsazure.management.models.AffinityGroupListResponse;

public class AzureDeleteStorage extends AzureAsyncOperations {
	private Logger logger = Logger.getLogger(this.getClass());
	private String storageId = null;
	private String regionId = null;
	private Configuration config = null;
	
	public AzureDeleteStorage(Configuration config, String storageId, String regionId) {
		this.config = config;
		this.storageId = storageId;
		this.regionId = regionId;
	}
	
	public void execute() throws CloudManagerFault {
		
    	OperationResponse operationResponse = new OperationResponse();
    	try{
        	logger.info("deleteStorage start: " + storageId );

        	ManagementClient managementClient = ManagementService.create(config);
			ComputeManagementClient computeManagementClient = ComputeManagementService.create(config);

			AffinityGroupOperations affinityGroupOperations = managementClient.getAffinityGroupsOperations();
			AffinityGroupListResponse affinityGroupListResponse = affinityGroupOperations.list();
        	VirtualMachineDiskListResponse vmds = computeManagementClient.getVirtualMachineDisksOperations().listDisks();
        	DeploymentOperations deploymentOperations = computeManagementClient.getDeploymentsOperations();
        	
        	for(VirtualMachineDisk vmd : vmds.getDisks()){
        		if(AzureUtil.compareLocation(regionId,vmd.getLocation(),vmd.getAffinityGroup(),affinityGroupListResponse.getAffinityGroups())) {
        			if(vmd.getName().equals(storageId)){
        				for(HostedService hostedService:computeManagementClient.getHostedServicesOperations().list()){
        					for (DeploymentSlot slot:AzureUtil.getDeploymentSlots()) {
        						DeploymentGetResponse deploymentGetResponse = null;
        						try {
        				 			deploymentGetResponse = deploymentOperations.getBySlot(hostedService.getServiceName(),slot);
        			 			}
        			 			catch (ServiceException e) {
        			 				if (e.getErrorCode().equals("ResourceNotFound"))
        			 					continue;
        			 				logger.error("deleteStorage: " + storageId + "(" + e.getErrorCode() +") "+ e.getMessage());
        			 				throw new CloudManagerFault(e.getMessage(), e);
        			 			}
        						for (Role role:deploymentGetResponse.getRoles()) {
        			 				for(DataVirtualHardDisk dvhd : role.getDataVirtualHardDisks()){
        			 					if(dvhd.getName().equals(storageId)){
        			 						VirtualMachineDiskOperations virtualMachineDiskOperations = computeManagementClient.getVirtualMachineDisksOperations();

        		 					        logger.info("VirtualMachineDiskOperations.beginDeletingDataDisk(" + vmd.getUsageDetails().getHostedServiceName() +","+ vmd.getUsageDetails().getDeploymentName() +","+ vmd.getUsageDetails().getRoleName() +","+ dvhd.getLogicalUnitNumber()==null?0:dvhd.getLogicalUnitNumber() +")");
        		 					        operationResponse = virtualMachineDiskOperations.beginDeletingDataDisk(vmd.getUsageDetails().getHostedServiceName(),vmd.getUsageDetails().getDeploymentName(),vmd.getUsageDetails().getRoleName(),dvhd.getLogicalUnitNumber()==null?0:dvhd.getLogicalUnitNumber(),true);
        		 					        logger.info("RequestId:" + operationResponse.getRequestId());
        		 					        
        		 					        for(;;){
        		 				        		OperationStatusResponse operationStatusResponse = computeManagementClient.getOperationStatus(operationResponse.getRequestId());
        		 				     			if (!operationStatusResponse.getStatus().equals(OperationStatus.InProgress)) {
        		 				     				logger.info("deleting " + getClass().getSimpleName() + "...");
        		 				     				if(operationStatusResponse.getStatus().equals(OperationStatus.Succeeded)){
        		 				     					logger.info("successful in deleting " + getClass().getSimpleName() + "...");
        		 				     				}else{
        		 				     					logger.error("failed in deleting " + operationStatusResponse.getError());
        		 				     					putLog("DeleteStorage","DeleteStorage was failed",operationStatusResponse.getError().getMessage());
        							 					throw new CloudManagerFault(operationStatusResponse.getError().getMessage(),new Exception(operationStatusResponse.getError().getCode()));
        		 				     				}
        		 				     				break;
        		 				     			}
        		 				        	}
        	                	        	return;
        			 					}
        			 				}
        			 			}
        					}
        				}
        			}
        		}
        	}
        	
        	VirtualMachineDiskOperations virtualMachineDiskOperations = computeManagementClient.getVirtualMachineDisksOperations();
        	
        	logger.info("VirtualMachineDiskOperations.deleteDisk(" + storageId +")");
        	operationResponse = virtualMachineDiskOperations.deleteDisk(storageId, true);
        	logger.info("RequestId:" + operationResponse.getRequestId());

        	for(;;){
	    		OperationStatusResponse operationStatusResponse = computeManagementClient.getOperationStatus(operationResponse.getRequestId());
	 			if (!operationStatusResponse.getStatus().equals(OperationStatus.InProgress)) {
	 				logger.info("deleting " + getClass().getSimpleName() + "...");
	 				if(operationStatusResponse.getStatus().equals(OperationStatus.Succeeded)){
	 					logger.info("successful in deleting " + getClass().getSimpleName() + "...");
	 				}else{
	 					logger.error("failed in deleting " + operationStatusResponse.getError());
		 				putLog("DeleteStorage","DeleteStorage was failed",operationStatusResponse.getError().getMessage());
	 					throw new CloudManagerFault(operationStatusResponse.getError().getMessage(),new Exception(operationStatusResponse.getError().getCode()));
	 				}
	 				break;
	 			}
        	}
        	
		}catch(ServiceException e){
			logger.error("deleteStorage: " + storageId + "(" + e.getErrorCode() +") "+ e.getMessage());
			putLog("DeleteStorage","DeleteStorage was failed",e.getMessage());
			throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), e);
		}catch(Exception e){
			logger.error("deleteStorage: " + storageId + " " + e.getMessage());
			putLog("DeleteStorage","DeleteStorage was failed",e.getMessage());
			throw new CloudManagerFault(e.getMessage(), e);
	    } finally {
	    	logger.info("deleteStorage end: " + storageId );
	    }		
	}
}
