package com.clustercontrol.cloud.azure.bean;

import com.clustercontrol.cloud.bean.CreateStorageRequest;
import com.clustercontrol.cloud.validation.annotation.ElementId;
import com.clustercontrol.ws.azure.HostCacheInfo;
import com.microsoft.windowsazure.management.compute.models.VirtualHardDiskHostCaching;

public class AzureCreateStorageRequest extends CreateStorageRequest{
	public AzureCreateStorageRequest() {
		super();
	}

	public AzureCreateStorageRequest(String instanceName,
									 String cloudServiceName,
									 String storageAccountName,
									 String containerName,
									 Integer lun,
									 VirtualHardDiskHostCaching virtualHardDiskHostCaching) {
		this.instanceName = instanceName;
		this.cloudServiceName = cloudServiceName;
		this.storageAccountName = storageAccountName;
		this.containerName = containerName;
		this.virtualHardDiskHostCaching = virtualHardDiskHostCaching;
		this.lun = lun;
	}
	private String instanceName;
	private String cloudServiceName;
	private String storageAccountName;
	private String containerName;
	private VirtualHardDiskHostCaching virtualHardDiskHostCaching;
	private String storageID;
	private Integer lun;

	/**
	 * インスタンス名を取得します。
	 *
	 * @return インスタンス名。
	 */
	@ElementId("instanceName")
	public String getInstanceName() {
		return instanceName;
	}
	/**
	 * インスタンス名を指定します。
	 *
	 * @param instanceName　インスタンス名。
	 */
	public void setInstanceName(String instanceName) {
		this.instanceName = instanceName;
	}

	/**
	 * クラウドサービス名を取得します。
	 *
	 * @return クラウドサービス名。
	 */
	@ElementId("cloudServiceName")
	public String getCloudServiceName() {
		return cloudServiceName;
	}
	/**
	 * クラウドサービス名を指定します。
	 *
	 * @param instanceName　インスタンス名。
	 */
	public void setCloudServiceName(String cloudServiceName) {
		this.cloudServiceName = cloudServiceName;
	}

	/**
	 * ストレージアカウント名を取得します。
	 *
	 * @return ストレージアカウント名。
	 */
	@ElementId("storageAccountName")
	public String getStorageAccountName() {
		return storageAccountName;
	}
	/**
	 * ストレージアカウント名を指定します。
	 *
	 * @param storageAccountName　ストレージアカウント名。
	 */
	public void setStorageAccountName(String storageAccountName) {
		this.storageAccountName = storageAccountName;
	}

	/**
	 * コンテナー名を取得します。
	 *
	 * @return コンテナー名。
	 */
	@ElementId("containerName")
	public String getContainerName() {
		return this.containerName;
	}
	/**
	 * コンテナー名を指定します。
	 *
	 * @param containerName　コンテナー名。
	 */
	public void setContainerName(String containerName) {
		this.containerName = containerName;
	}

	/**
	 * ホストキャッシュ設定を取得します。
	 *
	 * @return ホストキャッシュ設定
	 */
	public VirtualHardDiskHostCaching getVirtualHardDiskHostCaching() {
		if(this.virtualHardDiskHostCaching.equals(HostCacheInfo.hostCahe_READ_WRITE)){
			return VirtualHardDiskHostCaching.ReadWrite;
		}else if(this.virtualHardDiskHostCaching.equals(HostCacheInfo.hostCahe_READ_ONLY)){
			return VirtualHardDiskHostCaching.ReadOnly;
		}else{
			return VirtualHardDiskHostCaching.None;
		}
	}

	/**
	 * ホストキャッシュ設定を指定します。
	 *
	 * @param virtualHardDiskHostCaching　ホストキャッシュ設定。
	 */
	public void setVirtualHardDiskHostCaching(VirtualHardDiskHostCaching virtualHardDiskHostCaching) {
		this.virtualHardDiskHostCaching = virtualHardDiskHostCaching;
	}
	
	/**
	 * ストレージIDを取得します。
	 *
	 * @return ストレージID。
	 */
	@ElementId("storageID")
	public String getStorageID() {
		return storageID;
	}
	/**
	 * ストレージ名を指定します。
	 *
	 * @param storageID　ストレージID。
	 */
	public void setStorageID(String storageID) {
		this.storageID = storageID;
	}
	
	/**
	 * LUNを取得します。
	 *
	 * @return LUN。
	 */
	@ElementId("lun")
	public Integer getLUN() {
		return lun;
	}
	/**
	 * LUNを指定します。
	 *
	 * @param lun　LUN。
	 */
	public void setLUN(Integer lun) {
		this.lun = lun;
	}
	
}
