/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.implementation;

import com.microsoft.windowsazure.core.pipeline.jersey.IdempotentClientFilter;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.services.media.implementation.OAuthTokenManager;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import java.net.URISyntaxException;

public class OAuthFilter
extends IdempotentClientFilter {
    private final OAuthTokenManager oAuthTokenManager;

    public OAuthFilter(OAuthTokenManager oAuthTokenManager) {
        this.oAuthTokenManager = oAuthTokenManager;
    }

    public ClientResponse doHandle(ClientRequest clientRequest) {
        String accessToken;
        try {
            accessToken = this.oAuthTokenManager.getAccessToken();
        }
        catch (ServiceException e) {
            throw new ClientHandlerException((Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new ClientHandlerException((Throwable)e);
        }
        clientRequest.getHeaders().add((Object)"Authorization", (Object)("Bearer " + accessToken));
        return this.getNext().handle(clientRequest);
    }
}

