/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.implementation;

import com.microsoft.windowsazure.core.UserAgentFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.core.pipeline.jersey.ClientConfigSettings;
import com.microsoft.windowsazure.core.pipeline.jersey.ClientFilterAdapter;
import com.microsoft.windowsazure.core.pipeline.jersey.ClientFilterRequestAdapter;
import com.microsoft.windowsazure.core.pipeline.jersey.ClientFilterResponseAdapter;
import com.microsoft.windowsazure.core.pipeline.jersey.ServiceFilter;
import com.microsoft.windowsazure.services.media.MediaContract;
import com.microsoft.windowsazure.services.media.WritableBlobContainerContract;
import com.microsoft.windowsazure.services.media.entityoperations.EntityProxyData;
import com.microsoft.windowsazure.services.media.entityoperations.EntityRestProxy;
import com.microsoft.windowsazure.services.media.implementation.MediaBlobContainerWriter;
import com.microsoft.windowsazure.services.media.implementation.OAuthFilter;
import com.microsoft.windowsazure.services.media.implementation.RedirectFilter;
import com.microsoft.windowsazure.services.media.implementation.VersionHeadersFilter;
import com.microsoft.windowsazure.services.media.models.LocatorInfo;
import com.microsoft.windowsazure.services.media.models.LocatorType;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.net.URI;
import java.util.Arrays;
import javax.inject.Inject;

public class MediaRestProxy
extends EntityRestProxy
implements MediaContract {
    private RedirectFilter redirectFilter;
    private final ClientConfigSettings clientConfigSettings;

    @Inject
    public MediaRestProxy(Client channel, OAuthFilter authFilter, RedirectFilter redirectFilter, VersionHeadersFilter versionHeadersFilter, UserAgentFilter userAgentFilter, ClientConfigSettings clientConfigSettings) {
        super(channel, new ClientFilter[0]);
        this.clientConfigSettings = clientConfigSettings;
        this.redirectFilter = redirectFilter;
        channel.addFilter((ClientFilter)redirectFilter);
        channel.addFilter((ClientFilter)authFilter);
        channel.addFilter((ClientFilter)versionHeadersFilter);
        channel.addFilter((ClientFilter)new ClientFilterRequestAdapter((ServiceRequestFilter)userAgentFilter));
    }

    private MediaRestProxy(Client channel, ClientFilter[] filters, ClientConfigSettings clientConfigSettings) {
        super(channel, filters);
        this.clientConfigSettings = clientConfigSettings;
    }

    public MediaContract withFilter(ServiceFilter filter) {
        ClientFilter[] currentFilters = this.getFilters();
        ClientFilter[] newFilters = Arrays.copyOf(currentFilters, currentFilters.length + 1);
        newFilters[currentFilters.length] = new ClientFilterAdapter(filter);
        return new MediaRestProxy(this.getChannel(), newFilters, this.clientConfigSettings);
    }

    public MediaContract withRequestFilterFirst(ServiceRequestFilter serviceRequestFilter) {
        ClientFilter[] currentFilters = this.getFilters();
        ClientFilter[] newFilters = new ClientFilter[currentFilters.length + 1];
        System.arraycopy(currentFilters, 0, newFilters, 1, currentFilters.length);
        newFilters[0] = new ClientFilterRequestAdapter(serviceRequestFilter);
        return new MediaRestProxy(this.getChannel(), newFilters, this.clientConfigSettings);
    }

    public MediaContract withRequestFilterLast(ServiceRequestFilter serviceRequestFilter) {
        ClientFilter[] currentFilters = this.getFilters();
        ClientFilter[] newFilters = Arrays.copyOf(currentFilters, currentFilters.length + 1);
        newFilters[currentFilters.length] = new ClientFilterRequestAdapter(serviceRequestFilter);
        return new MediaRestProxy(this.getChannel(), newFilters, this.clientConfigSettings);
    }

    public MediaContract withResponseFilterFirst(ServiceResponseFilter serviceResponseFilter) {
        ClientFilter[] currentFilters = this.getFilters();
        ClientFilter[] newFilters = new ClientFilter[currentFilters.length + 1];
        System.arraycopy(currentFilters, 0, newFilters, 1, currentFilters.length);
        newFilters[0] = new ClientFilterResponseAdapter(serviceResponseFilter);
        return new MediaRestProxy(this.getChannel(), newFilters, this.clientConfigSettings);
    }

    public MediaContract withResponseFilterLast(ServiceResponseFilter serviceResponseFilter) {
        ClientFilter[] currentFilters = this.getFilters();
        ClientFilter[] newFilters = Arrays.copyOf(currentFilters, currentFilters.length + 1);
        newFilters[currentFilters.length] = new ClientFilterResponseAdapter(serviceResponseFilter);
        return new MediaRestProxy(this.getChannel(), newFilters, this.clientConfigSettings);
    }

    @Override
    protected EntityProxyData createProxyData() {
        return new EntityProxyData(){

            @Override
            public URI getServiceUri() {
                return MediaRestProxy.this.redirectFilter.getBaseURI();
            }
        };
    }

    @Override
    public WritableBlobContainerContract createBlobWriter(LocatorInfo locator) {
        if (locator.getLocatorType() != LocatorType.SAS) {
            throw new IllegalArgumentException("Can only write to SAS locators");
        }
        LocatorParser p = new LocatorParser(locator);
        return new MediaBlobContainerWriter(this.createUploaderClient(), p.getAccountName(), p.getStorageUri(), p.getContainer(), p.getSASToken());
    }

    private Client createUploaderClient() {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        this.clientConfigSettings.applyConfig((ClientConfig)clientConfig);
        Client client = Client.create((ClientConfig)clientConfig);
        this.clientConfigSettings.applyConfig(client);
        return client;
    }

    private static class LocatorParser {
        private URI locatorPath;

        public LocatorParser(LocatorInfo locator) {
            this.locatorPath = URI.create(locator.getPath());
        }

        public String getAccountName() {
            return this.locatorPath.getHost().split("\\.")[0];
        }

        public String getStorageUri() {
            return this.locatorPath.getScheme() + "://" + this.locatorPath.getAuthority();
        }

        public String getContainer() {
            return this.locatorPath.getPath().substring(1);
        }

        public String getSASToken() {
            return this.locatorPath.getRawQuery();
        }
    }
}

