/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.entityoperations;

import com.microsoft.windowsazure.core.pipeline.PipelineHelpers;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.services.media.entityoperations.EntityActionOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityContract;
import com.microsoft.windowsazure.services.media.entityoperations.EntityCreateOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityDeleteOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityGetOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityListOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityProxyData;
import com.microsoft.windowsazure.services.media.entityoperations.EntityTypeActionOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityUpdateOperation;
import com.microsoft.windowsazure.services.media.models.ListResult;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.ws.rs.core.MediaType;

public abstract class EntityRestProxy
implements EntityContract {
    private final ExecutorService executorService;
    private final Client channel;
    private final ClientFilter[] filters;

    public EntityRestProxy(Client channel, ClientFilter[] filters) {
        this.channel = channel;
        this.filters = filters;
        this.executorService = Executors.newCachedThreadPool();
    }

    protected Client getChannel() {
        return this.channel;
    }

    protected ExecutorService getExecutorService() {
        return this.executorService;
    }

    protected ClientFilter[] getFilters() {
        return this.filters;
    }

    protected abstract EntityProxyData createProxyData();

    private WebResource getResource(String entityName) {
        WebResource resource = this.channel.resource(entityName);
        for (ClientFilter filter : this.filters) {
            resource.addFilter(filter);
        }
        return resource;
    }

    private WebResource.Builder getResource(EntityOperation operation) throws ServiceException {
        return (WebResource.Builder)this.getResource(operation.getUri()).type(operation.getContentType()).accept(new MediaType[]{operation.getAcceptType()});
    }

    @Override
    public <T> T create(EntityCreateOperation<T> creator) throws ServiceException {
        creator.setProxyData(this.createProxyData());
        Object rawResponse = this.getResource(creator).post(creator.getResponseClass(), creator.getRequestContents());
        Object processedResponse = creator.processResponse(rawResponse);
        return (T)processedResponse;
    }

    @Override
    public <T> T get(EntityGetOperation<T> getter) throws ServiceException {
        getter.setProxyData(this.createProxyData());
        Object rawResponse = this.getResource(getter).get(getter.getResponseClass());
        Object processedResponse = getter.processResponse(rawResponse);
        return (T)processedResponse;
    }

    @Override
    public <T> ListResult<T> list(EntityListOperation<T> lister) throws ServiceException {
        lister.setProxyData(this.createProxyData());
        Object rawResponse = ((WebResource.Builder)this.getResource(lister.getUri()).queryParams(lister.getQueryParameters()).type(lister.getContentType()).accept(new MediaType[]{lister.getAcceptType()})).get(lister.getResponseGenericType());
        Object processedResponse = lister.processResponse(rawResponse);
        return (ListResult)processedResponse;
    }

    @Override
    public void update(EntityUpdateOperation updater) throws ServiceException {
        updater.setProxyData(this.createProxyData());
        Object rawResponse = ((WebResource.Builder)this.getResource(updater).header("X-HTTP-METHOD", (Object)"MERGE")).post(ClientResponse.class, updater.getRequestContents());
        PipelineHelpers.throwIfNotSuccess((ClientResponse)((ClientResponse)rawResponse));
        updater.processResponse(rawResponse);
    }

    @Override
    public void delete(EntityDeleteOperation deleter) throws ServiceException {
        deleter.setProxyData(this.createProxyData());
        this.getResource(deleter.getUri()).delete();
    }

    @Override
    public <T> T action(EntityTypeActionOperation<T> entityTypeActionOperation) throws ServiceException {
        entityTypeActionOperation.setProxyData(this.createProxyData());
        WebResource.Builder webResource = (WebResource.Builder)((WebResource.Builder)((WebResource.Builder)this.getResource(entityTypeActionOperation.getUri()).queryParams(entityTypeActionOperation.getQueryParameters()).accept(new MediaType[]{entityTypeActionOperation.getAcceptType()}).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE})).entity(entityTypeActionOperation.getRequestContents(), MediaType.APPLICATION_XML_TYPE)).type("application/xml");
        ClientResponse clientResponse = (ClientResponse)webResource.method(entityTypeActionOperation.getVerb(), ClientResponse.class);
        return entityTypeActionOperation.processTypeResponse(clientResponse);
    }

    @Override
    public void action(EntityActionOperation entityActionOperation) throws ServiceException {
        entityActionOperation.processResponse(this.getActionClientResponse(entityActionOperation));
    }

    private ClientResponse getActionClientResponse(EntityActionOperation entityActionOperation) {
        entityActionOperation.setProxyData(this.createProxyData());
        WebResource.Builder webResource = (WebResource.Builder)((WebResource.Builder)this.getResource(entityActionOperation.getUri()).queryParams(entityActionOperation.getQueryParameters()).accept(new MediaType[]{entityActionOperation.getAcceptType()}).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE})).type(MediaType.APPLICATION_XML_TYPE);
        webResource = entityActionOperation.getRequestContents() != null ? (WebResource.Builder)webResource.entity(entityActionOperation.getRequestContents(), entityActionOperation.getContentType()) : (WebResource.Builder)webResource.header("Content-Length", (Object)"0");
        return (ClientResponse)webResource.method(entityActionOperation.getVerb(), ClientResponse.class);
    }
}

