/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.azure.factory;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.azure.factory.AzureAsyncOperations;
import com.microsoft.windowsazure.Configuration;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.management.compute.ComputeManagementClient;
import com.microsoft.windowsazure.management.compute.ComputeManagementService;
import com.microsoft.windowsazure.management.compute.VirtualMachineOperations;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineStartRolesParameters;
import org.apache.log4j.Logger;

public class AzureStartInstance
extends AzureAsyncOperations {
    private Logger logger = Logger.getLogger(this.getClass());
    private Configuration config = null;
    private String cloudServiceName = null;
    private String deploymentName = null;

    public AzureStartInstance(Configuration config, String cloudServiceName, String deploymentName) {
        this.config = config;
        this.cloudServiceName = cloudServiceName;
        this.deploymentName = deploymentName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute() throws CloudManagerFault {
        OperationResponse operationResponse = new OperationResponse();
        ComputeManagementClient computeManagementClient = ComputeManagementService.create((Configuration)this.config);
        VirtualMachineOperations virtualMachineOperations = computeManagementClient.getVirtualMachinesOperations();
        try {
            VirtualMachineStartRolesParameters startPrm = new VirtualMachineStartRolesParameters();
            startPrm.setRoles(this.getParams());
            this.logger.info((Object)("VirtualMachineOperations.beginStartingRoles(" + this.cloudServiceName + "," + this.deploymentName + ")"));
            operationResponse = virtualMachineOperations.beginStartingRoles(this.cloudServiceName, this.deploymentName, startPrm);
            this.logger.info((Object)("RequestId:" + operationResponse.getRequestId()));
            while (true) {
                OperationStatusResponse operationStatusResponse;
                if (!(operationStatusResponse = computeManagementClient.getOperationStatus(operationResponse.getRequestId())).getStatus().equals((Object)OperationStatus.InProgress)) {
                    this.logger.info((Object)("Starting " + this.getClass().getSimpleName() + "..."));
                    if (operationStatusResponse.getStatus().equals((Object)OperationStatus.Succeeded)) {
                        this.logger.info((Object)("successful in Starting " + this.getClass().getSimpleName() + "..."));
                        return;
                    }
                    this.logger.error((Object)("failed in Starting " + operationStatusResponse.getError()));
                    this.putLog("StartInstance", "StartInstance was failed", operationStatusResponse.getError().getMessage());
                    throw new CloudManagerFault(operationStatusResponse.getError().getMessage(), (Throwable)new Exception(operationStatusResponse.getError().getCode()));
                }
                continue;
                break;
            }
        }
        catch (Exception e) {
            this.putLog("StartInstance", "StartInstance was failed", e.getMessage());
            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
        }
        finally {
            this.logger.info((Object)("Finish AzureStartInstance:" + this.getParams()));
        }
    }
}

