/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.azure.factory;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.Filter;
import com.clustercontrol.cloud.ICloudContext;
import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.azure.AzureOptionPropertyConstants;
import com.clustercontrol.cloud.azure.bean.AzurePendingInstances;
import com.clustercontrol.cloud.azure.bean.AzurePendingStartInstance;
import com.clustercontrol.cloud.azure.bean.AzurePendingStopInstance;
import com.clustercontrol.cloud.azure.factory.AzureAsyncExecution;
import com.clustercontrol.cloud.azure.factory.AzureDeleteInstance;
import com.clustercontrol.cloud.azure.factory.AzureDeleteInstanceBackup;
import com.clustercontrol.cloud.azure.factory.AzureDeleteStorage;
import com.clustercontrol.cloud.azure.factory.AzureDeleteStorageBackup;
import com.clustercontrol.cloud.azure.factory.AzureDetachStorage;
import com.clustercontrol.cloud.azure.factory.ListBlobsResult;
import com.clustercontrol.cloud.azure.util.AzureConstants;
import com.clustercontrol.cloud.azure.util.AzureUtil;
import com.clustercontrol.cloud.bean.Image;
import com.clustercontrol.cloud.bean.InstanceStateChange;
import com.clustercontrol.cloud.bean.InstanceStateKind;
import com.clustercontrol.cloud.bean.PlatformKind;
import com.clustercontrol.cloud.bean.Snapshot;
import com.clustercontrol.cloud.bean.StorageAttachmentStateKind;
import com.clustercontrol.cloud.bean.StorageStateKind;
import com.clustercontrol.cloud.bean.Tag;
import com.clustercontrol.cloud.bean.Zone;
import com.clustercontrol.cloud.dao.CloudInstanceDao;
import com.clustercontrol.cloud.dao.CloudStorageBackupDao;
import com.clustercontrol.cloud.persistence.EntityManagerEx;
import com.clustercontrol.cloud.persistence.Transactional;
import com.microsoft.windowsazure.Configuration;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.AffinityGroupOperations;
import com.microsoft.windowsazure.management.ManagementClient;
import com.microsoft.windowsazure.management.ManagementService;
import com.microsoft.windowsazure.management.compute.ComputeManagementClient;
import com.microsoft.windowsazure.management.compute.ComputeManagementService;
import com.microsoft.windowsazure.management.compute.DeploymentOperations;
import com.microsoft.windowsazure.management.compute.HostedServiceOperations;
import com.microsoft.windowsazure.management.compute.VirtualMachineOSImageOperations;
import com.microsoft.windowsazure.management.compute.models.DataVirtualHardDisk;
import com.microsoft.windowsazure.management.compute.models.DeploymentGetResponse;
import com.microsoft.windowsazure.management.compute.models.DeploymentSlot;
import com.microsoft.windowsazure.management.compute.models.HostedServiceListResponse;
import com.microsoft.windowsazure.management.compute.models.Role;
import com.microsoft.windowsazure.management.compute.models.RoleInstance;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineDiskGetResponse;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineDiskListResponse;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineOSImageCreateParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineOSImageCreateResponse;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineOSImageListResponse;
import com.microsoft.windowsazure.management.models.AffinityGroupListResponse;
import com.microsoft.windowsazure.management.storage.StorageAccountOperations;
import com.microsoft.windowsazure.management.storage.StorageManagementClient;
import com.microsoft.windowsazure.management.storage.StorageManagementService;
import com.microsoft.windowsazure.management.storage.models.StorageAccount;
import com.microsoft.windowsazure.management.storage.models.StorageAccountListResponse;
import com.microsoft.windowsazure.services.blob.BlobContract;
import com.microsoft.windowsazure.services.blob.BlobService;
import com.microsoft.windowsazure.services.blob.models.CreateBlobOptions;
import com.microsoft.windowsazure.services.blob.models.GetBlobResult;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.persistence.Query;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;

@Transactional(value=Transactional.TransactionType.Supported)
public class AzureResourceManagement
implements IResourceManagement,
AzureConstants {
    public static String RT_Instance = "AZURE";
    public static String RT_Image = "AZURE_Template";
    public static String RT_Storage = "AZURE_Volume";
    public static String RT_Snapshot = "AZURE_Snapshot";
    public static String RT_LoadBalancer = "LBA";
    public static String RT_InstanceBackup = "InstanceBackup";
    public static String RT_StorageBackup = "StorageBackup";
    private IResourceManagement.IRegion region;
    private IResourceManagement.ICredential credential;
    private IResourceManagement.IStore store;

    public void setAccessDestination(IResourceManagement.ICredential credential, IResourceManagement.IRegion region) {
        this.region = region;
        this.credential = credential;
    }

    public void setStore(IResourceManagement.IStore store) {
        this.store = store;
    }

    public IResourceManagement.ICredential getCledential() {
        return this.credential;
    }

    public IResourceManagement.IRegion getRegion() {
        return this.region;
    }

    public void disconnect() {
    }

    public IResourceManagement.Instance createInstance(String id, String name, String flavor, String imageId, String zone, String instanceDetail, List<Tag> tags) throws CloudManagerFault {
        Logger logger = Logger.getLogger(this.getClass());
        logger.info((Object)"Create Instance start");
        logger.info((Object)("Param instanceId:" + id + " instanceName:" + name + " ImageId:" + imageId + " Zone:" + zone));
        IResourceManagement.Instance instance = new IResourceManagement.Instance();
        instance.setName(name);
        instance.setFlavor(flavor);
        instance.setImageId(imageId);
        instance.setZone(zone);
        instance.setTags(tags);
        for (Tag tag : tags) {
            logger.info((Object)("Tag key:" + tag.getKey() + " Value:" + tag.getValue()));
            if (tag.getKey().equals("PlatForm")) {
                instance.setPlatform(tag.getValue().toLowerCase().equals("linux") ? PlatformKind.linux : PlatformKind.windows);
                continue;
            }
            if (!tag.getKey().equals("NodeName")) continue;
            instance.setHostName(tag.getValue());
            instance.setInstanceId(tag.getValue());
        }
        instance.setState(InstanceStateKind.pending);
        AzurePendingInstances cond = AzurePendingInstances.getInstance();
        cond.addAzureInstance(instance, this.getRegion().getName(), this.getCledential().getAccessKey());
        logger.info((Object)"Create Instance end");
        return instance;
    }

    private Configuration getConfiguration() throws Exception {
        Configuration config = AzureUtil.getConfiguration(this.getCledential().getAccessKey(), this.getCledential().getSecretKey());
        return config;
    }

    public void deleteInstance(String instanceId) throws CloudManagerFault {
        Logger logger = Logger.getLogger(this.getClass());
        try {
            logger.info((Object)("deleteInstance start: " + instanceId));
            AzureDeleteInstance azureDeleteInstance = new AzureDeleteInstance(this.getConfiguration(), instanceId);
            if (AzureOptionPropertyConstants.azure_api_mode.value().equalsIgnoreCase("async")) {
                AzureAsyncExecution.getSingleton().put(azureDeleteInstance);
            } else {
                azureDeleteInstance.execute();
            }
        }
        catch (ServiceException e) {
            logger.error((Object)("deleteInstance: " + instanceId + " (" + e.getErrorCode() + ") " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("deleteInstance: " + instanceId + " " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
        }
        finally {
            logger.info((Object)("deleteInstance end: " + instanceId));
        }
    }

    protected static PlatformKind getOSType(String ostype) {
        if (Pattern.compile(AzureOptionPropertyConstants.azure_os_win_pattern.value(), 2).matcher(ostype).matches()) {
            return PlatformKind.windows;
        }
        if (Pattern.compile(AzureOptionPropertyConstants.azure_os_linux_pattern.value(), 2).matcher(ostype).matches()) {
            return PlatformKind.linux;
        }
        return PlatformKind.other;
    }

    public IResourceManagement.Instance getInstance(String instanceId) throws CloudManagerFault {
        IResourceManagement.Instance instance;
        block11: {
            Logger logger = Logger.getLogger(this.getClass());
            instance = null;
            try {
                if (instanceId != null) {
                    logger.debug((Object)("getting Instance: " + this.getRegion().getName() + " " + instanceId));
                    AzurePendingInstances cond = AzurePendingInstances.getInstance();
                    for (IResourceManagement.Instance pendingInstance : cond.getAzureInstances(this.getRegion().getName(), this.getCledential().getAccessKey())) {
                        if (!pendingInstance.getInstanceId().equals(instanceId)) continue;
                        instance = pendingInstance;
                    }
                    if (instance == null) {
                        instance = new IResourceManagement.Instance();
                        ArrayList<String> instanceIds = new ArrayList<String>();
                        instanceIds.add(instanceId);
                        CloudInstanceDao dao = this.getInstanceDAO(instanceId);
                        Configuration config = this.getConfiguration();
                        ComputeManagementClient computeManagementClient = ComputeManagementService.create((Configuration)config);
                        DeploymentOperations deploymentOperations = computeManagementClient.getDeploymentsOperations();
                        for (HostedServiceListResponse.HostedService hostService : computeManagementClient.getHostedServicesOperations().list().getHostedServices()) {
                            if (!hostService.getServiceName().equals(dao.getZone())) continue;
                            for (DeploymentSlot slot : AzureUtil.getDeploymentSlots()) {
                                DeploymentGetResponse deploymentGetResponse = null;
                                try {
                                    deploymentGetResponse = deploymentOperations.getBySlot(hostService.getServiceName(), slot);
                                }
                                catch (ServiceException e) {
                                    if (e.getErrorCode().equals("ResourceNotFound")) continue;
                                    logger.error((Object)("getInstances: (" + e.getErrorCode() + ") " + e.getMessage()));
                                    throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
                                }
                                for (Role role : deploymentGetResponse.getRoles()) {
                                    if (!role.getRoleName().equals(instanceId)) continue;
                                    for (RoleInstance roleinstance : deploymentGetResponse.getRoleInstances()) {
                                        if (!roleinstance.getRoleName().equalsIgnoreCase(role.getRoleName())) continue;
                                        ArrayList<Tag> tags = new ArrayList<Tag>();
                                        instance = this.convertInstance(hostService, role, roleinstance, slot.toString(), tags);
                                    }
                                    return instance;
                                }
                            }
                        }
                    }
                    logger.debug((Object)("Successful in getting Instance: " + this.getRegion().getName() + " " + instanceId));
                    break block11;
                }
                instance = new IResourceManagement.Instance();
                instance.setState(InstanceStateKind.terminated);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return instance;
    }

    public List<IResourceManagement.Instance> getInstances(String ... instanceIds) throws CloudManagerFault {
        return this.getInstances(Arrays.asList(instanceIds));
    }

    public List<String> getInstanceByCloudService(String cloudServiceName) throws CloudManagerFault {
        ArrayList<String> instanceIDs = new ArrayList<String>();
        for (IResourceManagement.Instance instance : this.getInstances(new ArrayList<String>())) {
            if (!instance.getZone().equals(cloudServiceName)) continue;
            instanceIDs.add(instance.getInstanceId());
        }
        return instanceIDs;
    }

    public List<IResourceManagement.Instance> getInstances(List<String> instanceIds) throws CloudManagerFault {
        Logger logger = Logger.getLogger(this.getClass());
        ArrayList<IResourceManagement.Instance> instances = new ArrayList<IResourceManagement.Instance>();
        try {
            logger.debug((Object)("getting Instances: " + this.getRegion().getName() + (!instanceIds.isEmpty() ? " " + instanceIds.toString() : "")));
            AzurePendingInstances cond = AzurePendingInstances.getInstance();
            instances.addAll(cond.getAzureInstances(this.getRegion().getName(), this.getCledential().getAccessKey()));
            Configuration config = this.getConfiguration();
            ManagementClient managementClient = ManagementService.create((Configuration)config);
            ComputeManagementClient computeManagementClient = ComputeManagementService.create((Configuration)config);
            HostedServiceOperations hostedServicesOperations = computeManagementClient.getHostedServicesOperations();
            DeploymentOperations deploymentOperations = computeManagementClient.getDeploymentsOperations();
            AffinityGroupOperations affinityGroupOperations = managementClient.getAffinityGroupsOperations();
            AffinityGroupListResponse affinityGroupListResponse = affinityGroupOperations.list();
            HostedServiceListResponse hostedServiceListResponse = hostedServicesOperations.list();
            for (HostedServiceListResponse.HostedService hostService : hostedServiceListResponse.getHostedServices()) {
                if (!AzureUtil.compareLocation(this.getRegion().getName(), hostService.getProperties().getLocation(), affinityGroupListResponse.getAffinityGroups())) continue;
                for (DeploymentSlot slot : AzureUtil.getDeploymentSlots()) {
                    DeploymentGetResponse deploymentGetResponse = null;
                    try {
                        deploymentGetResponse = deploymentOperations.getBySlot(hostService.getServiceName(), slot);
                    }
                    catch (ServiceException e) {
                        if (e.getErrorCode().equals("ResourceNotFound")) continue;
                        logger.error((Object)("getInstances: (" + e.getErrorCode() + ") " + e.getMessage()));
                        throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
                    }
                    for (Role role : deploymentGetResponse.getRoles()) {
                        for (RoleInstance roleinstance : deploymentGetResponse.getRoleInstances()) {
                            if (!instanceIds.isEmpty() && !instanceIds.contains(roleinstance.getRoleName()) || !roleinstance.getRoleName().equalsIgnoreCase(role.getRoleName()) || cond.isExist(role.getRoleName(), this.getRegion().getName(), this.getCledential().getAccessKey())) continue;
                            ArrayList<Tag> tags = new ArrayList<Tag>();
                            instances.add(this.convertInstance(hostService, role, roleinstance, slot.toString(), tags));
                        }
                    }
                }
            }
            logger.debug((Object)("Successful in getting Instances:" + this.getRegion().getName() + (!instanceIds.isEmpty() ? " " + instanceIds.toString() : "")));
        }
        catch (ServiceException e) {
            logger.error((Object)("getInstances: (" + e.getErrorCode() + ") " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("getInstances: " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
        }
        return instances;
    }

    protected IResourceManagement.Instance convertInstance(HostedServiceListResponse.HostedService hostedService, Role role, RoleInstance roleinstance, String slot, List<Tag> tags) throws CloudManagerFault {
        IResourceManagement.Instance instance = new IResourceManagement.Instance();
        instance.setResourceType(RT_Instance);
        instance.setInstanceId(role.getRoleName());
        instance.setName(role.getRoleName());
        instance.setFlavor(slot + (hostedService.getProperties() == null ? "" : (hostedService.getProperties().getAffinityGroup() == null ? "" : (hostedService.getProperties().getAffinityGroup().equals("") ? "" : "-" + hostedService.getProperties().getAffinityGroup()))));
        instance.setZone(hostedService.getServiceName());
        instance.setImageId(role.getOSVirtualHardDisk().getSourceImageName());
        instance.setTags(tags);
        if (role.getOSVirtualHardDisk().getOperatingSystem().isEmpty()) {
            throw new InternalManagerError("not found ostype of vm created. vm=" + role.getRoleName());
        }
        instance.setPlatform(AzureResourceManagement.getOSType(role.getOSVirtualHardDisk().getOperatingSystem()));
        InstanceStateKind state = roleinstance.getPowerState().toString().toLowerCase().equals("started") ? InstanceStateKind.running : InstanceStateKind.stopped;
        instance.setState(state);
        instance.setIpAddress(roleinstance.getIPAddress() == null ? null : roleinstance.getIPAddress().getHostAddress());
        instance.setActualResource((Object)role);
        return instance;
    }

    public InstanceStateChange startInstance(String instanceId) throws CloudManagerFault {
        Logger logger = Logger.getLogger(this.getClass());
        try {
            logger.info((Object)("startInstance() start:" + instanceId));
            AzurePendingStartInstance azureStartInstances = new AzurePendingStartInstance(this.getConfiguration(), instanceId, this.getCledential().getAccessKey());
            if (AzureOptionPropertyConstants.azure_api_mode.value().equalsIgnoreCase("async")) {
                AzureAsyncExecution.getSingleton().put(azureStartInstances);
            } else {
                azureStartInstances.execute();
            }
        }
        catch (ServiceException e) {
            logger.error((Object)("startInstance: " + instanceId + " (" + e.getErrorCode() + ") " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("startInstance: " + instanceId + " " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
        }
        finally {
            logger.info((Object)("startInstance() end:" + instanceId));
        }
        InstanceStateChange change = new InstanceStateChange();
        change.setPreviousState(InstanceStateKind.running);
        change.setCurrentState(InstanceStateKind.running);
        change.setInstanceId(instanceId);
        return change;
    }

    public InstanceStateChange stopInstance(String instanceId) throws CloudManagerFault {
        Logger logger = Logger.getLogger(this.getClass());
        try {
            logger.info((Object)("stopInstance() start:" + instanceId));
            AzurePendingStopInstance azureStopInstance = new AzurePendingStopInstance(this.getConfiguration(), instanceId, this.getCledential().getAccessKey());
            if (AzureOptionPropertyConstants.azure_api_mode.value().equalsIgnoreCase("async")) {
                AzureAsyncExecution.getSingleton().put(azureStopInstance);
            } else {
                azureStopInstance.execute();
            }
        }
        catch (ServiceException e) {
            logger.error((Object)("stopInstance: (" + e.getErrorCode() + ") " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("stopInstance: " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
        }
        finally {
            logger.info((Object)("stopInstance() end:" + instanceId));
        }
        InstanceStateChange change = new InstanceStateChange();
        change.setPreviousState(InstanceStateKind.shutting_down);
        change.setCurrentState(InstanceStateKind.shutting_down);
        change.setInstanceId(instanceId);
        return change;
    }

    public List<String> getInstanceFlavors() throws CloudManagerFault {
        ArrayList<String> instanceTypes = new ArrayList<String>();
        return instanceTypes;
    }

    public List<Zone> getZones() throws CloudManagerFault {
        ArrayList<Zone> zones = new ArrayList<Zone>();
        Logger logger = Logger.getLogger(this.getClass());
        try {
            Configuration config = this.getConfiguration();
            ComputeManagementClient computeManagementClient = ComputeManagementService.create((Configuration)config);
            HostedServiceOperations hostedServicesOperations = computeManagementClient.getHostedServicesOperations();
            HostedServiceListResponse hostedServiceListResponse = hostedServicesOperations.list();
            for (HostedServiceListResponse.HostedService hostedService : hostedServiceListResponse.getHostedServices()) {
                Zone zone = new Zone();
                zone.setName(hostedService.getServiceName());
                zones.add(zone);
            }
        }
        catch (ServiceException e) {
            logger.error((Object)("getZones: (" + e.getErrorCode() + ") " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("getZones: " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
        }
        logger.info((Object)"successful in get Cloud Services");
        return zones;
    }

    public void attachStorage(String instanceId, String storageId, String deviceName) throws CloudManagerFault {
    }

    public void detachStorage(String instanceId, String storageId) throws CloudManagerFault {
        Logger logger = Logger.getLogger(this.getClass());
        try {
            logger.info((Object)"detachStorage() start");
            AzureDetachStorage azureDetachStorage = new AzureDetachStorage(this.getConfiguration(), instanceId, storageId);
            if (AzureOptionPropertyConstants.azure_api_mode.value().equalsIgnoreCase("async")) {
                AzureAsyncExecution.getSingleton().put(azureDetachStorage);
            } else {
                azureDetachStorage.execute();
            }
        }
        catch (ServiceException e) {
            logger.error((Object)("detachStorage: (" + e.getErrorCode() + ") " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("detachStorage: " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
        }
        finally {
            logger.info((Object)"detachStorage() end");
        }
    }

    public IResourceManagement.Storage createStorage(String name, String flavor, int size, String snapshotId, String zone, String storageDetail) throws CloudManagerFault {
        IResourceManagement.Storage storage = new IResourceManagement.Storage();
        storage.setName(name);
        storage.setStorageId(name);
        storage.setSize(size);
        storage.setSnapshotId(snapshotId);
        storage.setZone(zone);
        storage.setResourceType(RT_Storage);
        storage.setState(StorageStateKind.creating);
        storage.setFlavor("Data");
        IResourceManagement.Storage.StorageAttachment sa = new IResourceManagement.Storage.StorageAttachment();
        sa = new IResourceManagement.Storage.StorageAttachment(name, "DataDisk", StorageAttachmentStateKind.attached, new Date());
        storage.setStorageAttachment(sa);
        return storage;
    }

    public void deleteStorage(String storageId) throws CloudManagerFault {
        Logger logger = Logger.getLogger(this.getClass());
        try {
            logger.info((Object)"deleteStorage() start");
            AzureDeleteStorage azureDeleteStorage = new AzureDeleteStorage(this.getConfiguration(), storageId, this.getRegion().getName());
            if (AzureOptionPropertyConstants.azure_api_mode.value().equalsIgnoreCase("async")) {
                AzureAsyncExecution.getSingleton().put(azureDeleteStorage);
            } else {
                azureDeleteStorage.execute();
            }
        }
        catch (ServiceException e) {
            logger.error((Object)("deleteStorage: " + storageId + "(" + e.getErrorCode() + ") " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("deleteStorage: " + storageId + " " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
        }
        finally {
            logger.info((Object)("deleteStorage end: " + storageId));
        }
    }

    public IResourceManagement.Storage getStorage(String storageId) throws CloudManagerFault {
        return new IResourceManagement.Storage();
    }

    public List<IResourceManagement.Storage> getStorages(String ... storageIds) throws CloudManagerFault {
        return this.getStorages(Arrays.asList(storageIds));
    }

    public static IResourceManagement.Storage convertStorage(VirtualMachineDiskListResponse.VirtualMachineDisk dataDisk, StorageAccount storageAccount) {
        IResourceManagement.Storage storage = new IResourceManagement.Storage();
        storage.setStorageId(dataDisk.getName());
        storage.setName(storageAccount.getName() + "-" + dataDisk.getName());
        storage.setSize(dataDisk.getLogicalSizeInGB());
        storage.setZone(dataDisk.getUsageDetails() == null ? "" : dataDisk.getUsageDetails().getHostedServiceName());
        storage.setResourceType(RT_Storage);
        storage.setFlavor(dataDisk.getOperatingSystemType() == null ? "Data" : dataDisk.getOperatingSystemType());
        IResourceManagement.Storage.StorageAttachment sa = new IResourceManagement.Storage.StorageAttachment();
        if (dataDisk.getUsageDetails() != null) {
            storage.setState(StorageStateKind.in_use);
            sa = new IResourceManagement.Storage.StorageAttachment(dataDisk.getUsageDetails().getRoleName(), dataDisk.getOperatingSystemType() == null ? "DataDisk" : "OSDisk", StorageAttachmentStateKind.attached, new Date());
        } else {
            storage.setState(StorageStateKind.available);
            sa = null;
        }
        storage.setStorageAttachment(sa);
        return storage;
    }

    public List<IResourceManagement.Storage> getStorages(List<String> storageIds) throws CloudManagerFault {
        ArrayList<IResourceManagement.Storage> storages = new ArrayList<IResourceManagement.Storage>();
        Logger logger = Logger.getLogger(this.getClass());
        try {
            logger.debug((Object)("getting Storages: " + this.getRegion().getName() + (!storageIds.isEmpty() ? " " + storageIds.toString() : "")));
            Configuration config = this.getConfiguration();
            ManagementClient managementClient = ManagementService.create((Configuration)config);
            ComputeManagementClient computeManagementClient = ComputeManagementService.create((Configuration)config);
            StorageManagementClient storageManagementClient = StorageManagementService.create((Configuration)config);
            AffinityGroupOperations affinityGroupOperations = managementClient.getAffinityGroupsOperations();
            StorageAccountOperations storageAccountOperations = storageManagementClient.getStorageAccountsOperations();
            AffinityGroupListResponse affinityGroupListResponse = affinityGroupOperations.list();
            StorageAccountListResponse storageServiceListResponse = storageAccountOperations.list();
            VirtualMachineDiskListResponse vmds = computeManagementClient.getVirtualMachineDisksOperations().listDisks();
            computeManagementClient.getHostedServicesOperations().list();
            for (VirtualMachineDiskListResponse.VirtualMachineDisk vmd : vmds.getDisks()) {
                if (!AzureUtil.compareLocation(this.getRegion().getName(), vmd.getLocation(), vmd.getAffinityGroup(), affinityGroupListResponse.getAffinityGroups())) continue;
                for (StorageAccount sa : storageServiceListResponse.getStorageAccounts()) {
                    String match = sa.getUri().toString().substring(sa.getUri().toString().lastIndexOf("/") + 1);
                    if (vmd.getMediaLinkUri().toString().indexOf("http://" + match + ".") != 0 && vmd.getMediaLinkUri().toString().indexOf("https://" + match + ".") != 0) continue;
                    storages.add(AzureResourceManagement.convertStorage(vmd, sa));
                }
            }
            logger.debug((Object)("Successful in getting Storages:" + this.getRegion().getName() + (!storageIds.isEmpty() ? " " + storageIds.toString() : "")));
        }
        catch (ServiceException e) {
            logger.error((Object)("getStorages: (" + e.getErrorCode() + ") " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("getStorages: " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
        }
        return storages;
    }

    public List<String> getStorageFlavors() throws CloudManagerFault {
        ArrayList<String> storageTypes = new ArrayList<String>();
        return storageTypes;
    }

    public IResourceManagement.StorageBackup createStorageBackup(String storageId, String name, String description, String backupOption) throws CloudManagerFault {
        IResourceManagement.StorageBackup storageBackup = new IResourceManagement.StorageBackup();
        VirtualMachineDiskListResponse.VirtualMachineDisk target_disk = null;
        StorageAccountOperations storageAccountOperations = null;
        Logger logger = Logger.getLogger(this.getClass());
        String storageAccountName = "";
        String containerName = "";
        String vhdFileName = "";
        AzureUtil.AzureServiceRequestFilter requestFilter = null;
        AzureUtil.AzureServiceResponseFilter responseFilter = null;
        try {
            Configuration config = this.getConfiguration();
            ComputeManagementClient computeManagementClient = ComputeManagementService.create((Configuration)config);
            StorageManagementClient storageManagementClient = StorageManagementService.create((Configuration)config);
            storageAccountOperations = storageManagementClient.getStorageAccountsOperations();
            VirtualMachineDiskListResponse vmds = computeManagementClient.getVirtualMachineDisksOperations().listDisks();
            for (VirtualMachineDiskListResponse.VirtualMachineDisk vmd : vmds.getDisks()) {
                if (!vmd.getName().equals(storageId)) continue;
                target_disk = new VirtualMachineDiskListResponse.VirtualMachineDisk();
                target_disk = vmd;
                storageAccountName = AzureUtil.getStorageAccountNameFromVHD(vmd.getMediaLinkUri().toString());
                containerName = AzureUtil.getContainerNameFromVHD(vmd.getMediaLinkUri().toString());
                vhdFileName = AzureUtil.getVHDFileNameFromVHD(vmd.getMediaLinkUri().toString());
                break;
            }
            if (target_disk != null) {
                Configuration blobconfig = null;
                blobconfig = AzureUtil.getBlobConfiguration(storageAccountName, storageAccountOperations.getKeys(storageAccountName).getPrimaryKey());
                BlobContract blobContract = null;
                responseFilter = new AzureUtil.AzureServiceResponseFilter();
                requestFilter = new AzureUtil.AzureServiceRequestFilter();
                requestFilter.changeURL(vhdFileName, vhdFileName + "?comp=snapshot");
                blobContract = (BlobContract)((BlobContract)BlobService.create((Configuration)blobconfig).withRequestFilterLast((ServiceRequestFilter)requestFilter)).withResponseFilterLast((ServiceResponseFilter)responseFilter);
                logger.info((Object)("BlobContract.createBlockBlob(" + containerName + "," + vhdFileName + ") Create snapshot"));
                blobContract.createBlockBlob(containerName, vhdFileName, null);
                String snapshot = responseFilter.getSnapShot();
                logger.info((Object)("RequestId:" + responseFilter.getRequestId() + " Create snapshot: " + containerName + "/" + vhdFileName + "?snapshot=" + snapshot + " snapshot-id=" + AzureUtil.getConvertSnapshotId(snapshot)));
                String backUpName = storageAccountName + "_" + containerName + "_" + AzureUtil.getConvertSnapshotId(snapshot);
                responseFilter.close();
                storageBackup.setName(name);
                storageBackup.setDescription(description);
                storageBackup.setStorageBackupId(backUpName);
                storageBackup.setStorageId(storageId);
                storageBackup.setCreateTime(new Date());
            }
        }
        catch (ServiceException e) {
            logger.error((Object)("createStorageBackup: (" + e.getErrorCode() + ") " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("createStorageBackup: " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
        }
        return storageBackup;
    }

    public void deleteStorageBackup(String storageBackupId) throws CloudManagerFault {
        Logger logger = Logger.getLogger(this.getClass());
        logger.info((Object)("deleteStorageBackup start: " + storageBackupId));
        try {
            AzureDeleteStorageBackup azureDeleteStorageBackup = new AzureDeleteStorageBackup(this.getConfiguration(), storageBackupId);
            if (AzureOptionPropertyConstants.azure_api_mode.value().equalsIgnoreCase("async")) {
                AzureAsyncExecution.getSingleton().put(azureDeleteStorageBackup);
            } else {
                azureDeleteStorageBackup.execute();
            }
        }
        catch (ServiceException e) {
            logger.error((Object)"Deleting Storage backup is failed...");
            logger.error((Object)("deleteStorageBackup: (" + e.getErrorCode() + ") " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"Deleting Storage backup is failed...");
            logger.error((Object)("deleteStorageBackup: " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
        }
        finally {
            logger.info((Object)("deleteStorageBackup end: " + storageBackupId));
        }
    }

    public List<Snapshot> getSnapshots(String ... snapshotIds) throws CloudManagerFault {
        return this.getSnapshotsWithFilter(new Filter("snapshot-id", snapshotIds));
    }

    public List<Snapshot> getSnapshots(List<String> snapshotIds) throws CloudManagerFault {
        return this.getSnapshotsWithFilter(new Filter("snapshot-id", snapshotIds));
    }

    public List<Snapshot> getSnapshotsWithFilter(Filter ... filters) throws CloudManagerFault {
        return this.getSnapshotsWithFilter(Arrays.asList(filters));
    }

    public List<Snapshot> getSnapshotsWithFilter(List<Filter> filters) throws CloudManagerFault {
        Logger logger = Logger.getLogger(this.getClass());
        ArrayList<Snapshot> snapShots = new ArrayList<Snapshot>();
        StorageAccountOperations storageAccountOperations = null;
        AzureUtil.AzureServiceResponseFilter response = new AzureUtil.AzureServiceResponseFilter();
        try {
            Configuration config = this.getConfiguration();
            ComputeManagementClient computeManagementClient = ComputeManagementService.create((Configuration)config);
            VirtualMachineDiskListResponse vmds = computeManagementClient.getVirtualMachineDisksOperations().listDisks();
            for (VirtualMachineDiskListResponse.VirtualMachineDisk vmd : vmds.getDisks()) {
                String storageAccountName = AzureUtil.getStorageAccountNameFromVHD(vmd.getMediaLinkUri().toString());
                String containerName = AzureUtil.getContainerNameFromVHD(vmd.getMediaLinkUri().toString());
                String vhdFileName = AzureUtil.getVHDFileNameFromVHD(vmd.getMediaLinkUri().toString());
                StorageManagementClient storageManagementClient = StorageManagementService.create((Configuration)config);
                storageAccountOperations = storageManagementClient.getStorageAccountsOperations();
                Configuration blobconfig = null;
                blobconfig = AzureUtil.getBlobConfiguration(storageAccountName, storageAccountOperations.getKeys(storageAccountName).getPrimaryKey());
                BlobContract blobContract = BlobService.create((Configuration)blobconfig);
                blobContract.getBlob(containerName, vhdFileName);
                for (StorageAccount sa : storageAccountOperations.list()) {
                    if (!vmd.getMediaLinkUri().toString().contains(sa.getName())) continue;
                    AzureUtil.AzureServiceRequestFilter request = new AzureUtil.AzureServiceRequestFilter();
                    request.changeURL("?", containerName + "?restype=container&include=snapshots&");
                    response.setUseBody();
                    blobContract = (BlobContract)((BlobContract)BlobService.create((Configuration)config).withRequestFilterLast((ServiceRequestFilter)request)).withResponseFilterLast((ServiceResponseFilter)response);
                    storageAccountOperations = storageManagementClient.getStorageAccountsOperations();
                    blobContract.listContainers();
                    JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ListBlobsResult.class});
                    Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                    ListBlobsResult listBlobsResult = (ListBlobsResult)jaxbUnmarshaller.unmarshal(response.getInputStream());
                    response.close();
                    for (ListBlobsResult.Blob blob : listBlobsResult.getBlobs()) {
                        logger.debug((Object)("ListBlobsResult: " + containerName + "/" + blob.getName() + blob.getSnapshot() != null ? " snapshot=" + blob.getSnapshot() : ""));
                        Snapshot ss = new Snapshot();
                        ss.setSnapshotId(AzureUtil.getConvertSnapshotId(blob.getSnapshot()));
                        ss.setName(blob.getName());
                        snapShots.add(ss);
                    }
                    logger.info((Object)"Successful in getting Snapshots");
                }
            }
        }
        catch (ServiceException e) {
            logger.error((Object)("getSnapshotsWithFilter: (" + e.getErrorCode() + ") " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("getSnapshotsWithFilter: " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
        }
        finally {
            if (response != null) {
                response.close();
                response = null;
            }
        }
        return snapShots;
    }

    public void deleteInstanceBackup(String instanceBackupId) throws CloudManagerFault {
        Logger logger = Logger.getLogger(this.getClass());
        try {
            logger.info((Object)("deleteInstanceBackup start: " + instanceBackupId));
            AzureDeleteInstanceBackup azureDeleteInstanceBackup = new AzureDeleteInstanceBackup(this.getConfiguration(), instanceBackupId);
            if (AzureOptionPropertyConstants.azure_api_mode.value().equalsIgnoreCase("async")) {
                AzureAsyncExecution.getSingleton().put(azureDeleteInstanceBackup);
            } else {
                azureDeleteInstanceBackup.execute();
            }
        }
        catch (ServiceException e) {
            logger.error((Object)("deleteInstanceBackup: (" + e.getErrorCode() + ") " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("deleteInstanceBackup: " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
        }
        finally {
            logger.info((Object)("deleteInstanceBackup end: " + instanceBackupId));
        }
    }

    public List<Image> getImages(String ... imageIds) throws CloudManagerFault {
        return this.getImagesWithFilter(new Filter("image-id", imageIds));
    }

    public List<Image> getImages(List<String> imageIds) throws CloudManagerFault {
        return this.getImagesWithFilter(new Filter("image-id", imageIds));
    }

    public List<Image> getImagesWithFilter(Filter ... filters) throws CloudManagerFault {
        return this.getImagesWithFilter(Arrays.asList(filters));
    }

    public List<Image> getImagesWithFilter(List<Filter> filters) throws CloudManagerFault {
        return new ArrayList<Image>();
    }

    public Snapshot getSnapshot(String snapshotId) throws CloudManagerFault {
        List<Snapshot> snapshots = this.getSnapshots(snapshotId);
        if (snapshots.isEmpty()) {
            throw IResourceManagement.ErrorCode.Resource_InvalidSnapshot_NotFound.cloudManagerFault(new Object[]{snapshotId});
        }
        return snapshots.get(0);
    }

    public Image getImage(String imageId) throws CloudManagerFault {
        List<Image> images = this.getImages(imageId);
        if (images.isEmpty()) {
            throw IResourceManagement.ErrorCode.Resource_InvalidImageID_NotFound.cloudManagerFault(new Object[]{imageId});
        }
        return images.get(0);
    }

    public IResourceManagement.Instance restoreInstance(String facilityId, String instanceBackupId, String name, String flavor, String zone, String instanceDetail, List<Tag> tags) throws CloudManagerFault {
        return new IResourceManagement.Instance();
    }

    public IResourceManagement.Storage restoreStorage(String storageBackupId, String name, String flavor, Integer size, String zone, String storageDetail) throws CloudManagerFault {
        return new IResourceManagement.Storage();
    }

    public IResourceManagement.StorageBackup getStorageBackup(String storageBackupId) throws CloudManagerFault {
        return new IResourceManagement.StorageBackup();
    }

    public List<IResourceManagement.StorageBackup> getStorageBackups(String ... storageBackupId) throws CloudManagerFault {
        return this.getStorageBackups(Arrays.asList(storageBackupId));
    }

    private CloudStorageBackupDao getStorageBackupDAO(String storageId) {
        Logger logger = Logger.getLogger(this.getClass());
        try {
            ICloudContext context = (ICloudContext)SessionService.current().get(ICloudContext.class);
            EntityManagerEx em = SessionService.current().getEntityManagerEx();
            Query query = em.createQuery("SELECT b FROM CloudStorageBackupDao b WHERE b.storageBackupId   = :target AND b.region            = :region AND b.accountResourceId = :accountResourceId ");
            query.setParameter("target", (Object)storageId);
            query.setParameter("region", (Object)context.getCurrentRegion().getRegion());
            query.setParameter("accountResourceId", (Object)context.getAccessDestionation().getCloudAccountResource().getAccountResourceId());
            ArrayList backups = new ArrayList(query.getResultList());
            return (CloudStorageBackupDao)backups.get(0);
        }
        catch (Exception e) {
            logger.error((Object)("getStorageBackupDAO: " + e.getMessage()));
            return null;
        }
    }

    private CloudInstanceDao getInstanceDAO(String instanceId) {
        Logger logger = Logger.getLogger(this.getClass());
        try {
            ICloudContext context = (ICloudContext)SessionService.current().get(ICloudContext.class);
            EntityManagerEx em = SessionService.current().getEntityManagerEx();
            Query query = em.createQuery("SELECT b FROM CloudInstanceDao b WHERE b.instanceId        = :instanceId AND b.region            = :region AND b.accountResourceId = :accountResourceId ");
            query.setParameter("instanceId", (Object)instanceId);
            query.setParameter("region", (Object)context.getCurrentRegion().getRegion());
            query.setParameter("accountResourceId", (Object)context.getAccessDestionation().getCloudAccountResource().getAccountResourceId());
            ArrayList backups = new ArrayList(query.getResultList());
            return (CloudInstanceDao)backups.get(0);
        }
        catch (Exception e) {
            logger.error((Object)("getStorageBackupDAO: " + e.getMessage()));
            return null;
        }
    }

    public List<IResourceManagement.StorageBackup> getStorageBackups(List<String> storageBackupIds) throws CloudManagerFault {
        ArrayList<IResourceManagement.StorageBackup> storageBackups = new ArrayList<IResourceManagement.StorageBackup>();
        Logger logger = Logger.getLogger(this.getClass());
        StorageAccountOperations storageAccountOperations = null;
        AzureUtil.AzureServiceRequestFilter request = new AzureUtil.AzureServiceRequestFilter();
        AzureUtil.AzureServiceResponseFilter response = new AzureUtil.AzureServiceResponseFilter();
        String snapshotID = "";
        VirtualMachineDiskGetResponse vmd = new VirtualMachineDiskGetResponse();
        String storageAccountName = "";
        String containerName = "";
        String vhdFileName = "";
        try {
            Configuration config = this.getConfiguration();
            ComputeManagementClient computeManagementClient = ComputeManagementService.create((Configuration)config);
            for (String storageBackupId : storageBackupIds) {
                CloudStorageBackupDao dao = this.getStorageBackupDAO(storageBackupId);
                vmd = computeManagementClient.getVirtualMachineDisksOperations().getDisk(dao.getBackupedData().getStorageId());
                storageAccountName = AzureUtil.getStorageAccountNameFromVHD(vmd.getMediaLinkUri().toString());
                containerName = AzureUtil.getContainerNameFromVHD(vmd.getMediaLinkUri().toString());
                vhdFileName = AzureUtil.getVHDFileNameFromVHD(vmd.getMediaLinkUri().toString());
                snapshotID = AzureUtil.getConvertSnapshotValue(storageBackupId.substring(storageBackupId.lastIndexOf("_") + 1));
                StorageManagementClient storageManagementClient = StorageManagementService.create((Configuration)config);
                storageAccountOperations = storageManagementClient.getStorageAccountsOperations();
                Configuration blobconfig = null;
                blobconfig = AzureUtil.getBlobConfiguration(storageAccountName, storageAccountOperations.getKeys(storageAccountName).getPrimaryKey());
                request.changeURL(vhdFileName, vhdFileName + "?snapshot=" + snapshotID);
                GetBlobResult blobRes = null;
                BlobContract blobContract = (BlobContract)((BlobContract)BlobService.create((Configuration)blobconfig).withRequestFilterLast((ServiceRequestFilter)request)).withResponseFilterLast((ServiceResponseFilter)response);
                try {
                    blobRes = blobContract.getBlob(containerName, vhdFileName);
                }
                catch (Exception e) {
                    logger.info((Object)("Snapshot is anavailable : vhd_file=" + vhdFileName + ", snapshotId=" + snapshotID));
                    continue;
                }
                if (blobRes == null) continue;
                IResourceManagement.StorageBackup storageBackup = new IResourceManagement.StorageBackup();
                storageBackup.setStorageBackupId(storageBackupId);
                storageBackups.add(storageBackup);
                logger.info((Object)("Get snapshot in success..." + containerName + "," + vhdFileName + "," + "snapshot=" + snapshotID + "," + storageBackupId));
            }
        }
        catch (ServiceException e) {
            logger.error((Object)("Get snapshot in failed... snapshot=" + snapshotID));
            logger.error((Object)("getStorageBackups: (" + e.getErrorCode() + ") " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("Get snapshot in failed... snapshot=" + snapshotID));
            logger.error((Object)("getStorageBackups: " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
        }
        finally {
            if (response != null) {
                response.close();
                response = null;
            }
        }
        return storageBackups;
    }

    public IResourceManagement.InstanceBackup getInstanceBackup(String instanceBackupId) throws CloudManagerFault {
        ArrayList<String> instanceBackupIds = new ArrayList<String>();
        instanceBackupIds.add(instanceBackupId);
        List<IResourceManagement.InstanceBackup> InstanceBackups = this.getInstanceBackups(instanceBackupIds);
        return InstanceBackups.get(0);
    }

    public List<IResourceManagement.InstanceBackup> getInstanceBackups(String ... instanceBackupIds) throws CloudManagerFault {
        return this.getInstanceBackups(Arrays.asList(instanceBackupIds));
    }

    public List<IResourceManagement.InstanceBackup> getInstanceBackups(List<String> instanceBackupIds) throws CloudManagerFault {
        ArrayList<IResourceManagement.InstanceBackup> instanceBackups = new ArrayList<IResourceManagement.InstanceBackup>();
        Logger logger = Logger.getLogger(this.getClass());
        try {
            Configuration config = this.getConfiguration();
            ComputeManagementClient computeManagementClient = ComputeManagementService.create((Configuration)config);
            VirtualMachineOSImageOperations virtualMachineOSImageOperations = computeManagementClient.getVirtualMachineOSImagesOperations();
            for (VirtualMachineOSImageListResponse.VirtualMachineOSImage vmimage : virtualMachineOSImageOperations.list()) {
                if (!instanceBackupIds.contains(vmimage.getName())) continue;
                IResourceManagement.InstanceBackup bkup = new IResourceManagement.InstanceBackup();
                bkup.setInstanceBackupId(vmimage.getName());
                bkup.setDescription(vmimage.getDescription());
                if (vmimage.getOperatingSystemType().equals("Linux")) {
                    bkup.setPlatform(PlatformKind.linux);
                } else if (vmimage.getOperatingSystemType().equals("Windows")) {
                    bkup.setPlatform(PlatformKind.windows);
                } else {
                    bkup.setPlatform(PlatformKind.other);
                }
                IResourceManagement.InstanceBackup.BackupedData bkupdata = new IResourceManagement.InstanceBackup.BackupedData();
                bkup.setBackupedData(bkupdata);
                instanceBackups.add(bkup);
            }
            logger.info((Object)("Successful in getting instances " + this.getClass().getSimpleName() + "..."));
        }
        catch (ServiceException e) {
            logger.error((Object)("getInstanceBackups: (" + e.getErrorCode() + ") " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("getInstanceBackups: " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
        }
        return instanceBackups;
    }

    public List<IResourceManagement.LoadBalancer> getLoadBalancers() throws CloudManagerFault {
        return new ArrayList<IResourceManagement.LoadBalancer>();
    }

    public void registerInstanceToLoadBalancer(String lbId, String instanceId) throws CloudManagerFault {
    }

    public void unregisterInstanceToLoadBalancer(String lbId, String instanceId) throws CloudManagerFault {
    }

    public IResourceManagement.InstanceBackup createInstanceBackup(String instanceId, String name, String description, Boolean noReboot, String backupOption) throws CloudManagerFault {
        return this.createInstanceBackup(instanceId, name, description, noReboot, null, backupOption);
    }

    public IResourceManagement.InstanceBackup createInstanceBackup(String instanceId, String name, String description, Boolean noReboot, List<String> storageIds, String backupOption) throws CloudManagerFault {
        IResourceManagement.InstanceBackup instanceBackup = new IResourceManagement.InstanceBackup();
        AzureUtil.AzureServiceRequestFilter request = new AzureUtil.AzureServiceRequestFilter();
        AzureUtil.AzureServiceResponseFilter response = new AzureUtil.AzureServiceResponseFilter();
        Logger logger = Logger.getLogger(this.getClass());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmss");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            OperationStatusResponse operationStatusResponse;
            Configuration config = this.getConfiguration();
            ComputeManagementClient computeManagementClient = ComputeManagementService.create((Configuration)config);
            ManagementClient managementClient = ManagementService.create((Configuration)config);
            Role targetRole = null;
            HashMap<String, String> attachedDisks = new HashMap<String, String>();
            HostedServiceOperations hostedServicesOperations = computeManagementClient.getHostedServicesOperations();
            DeploymentOperations deploymentOperations = computeManagementClient.getDeploymentsOperations();
            VirtualMachineOSImageOperations virtualMachineOSImageOperations = computeManagementClient.getVirtualMachineOSImagesOperations();
            StorageManagementClient storageManagementClient = StorageManagementService.create((Configuration)config);
            StorageAccountOperations storageAccountOperations = storageManagementClient.getStorageAccountsOperations();
            AffinityGroupOperations affinityGroupOperations = managementClient.getAffinityGroupsOperations();
            AffinityGroupListResponse affinityGroupListResponse = affinityGroupOperations.list();
            HostedServiceListResponse hostedServiceListResponse = hostedServicesOperations.list();
            for (HostedServiceListResponse.HostedService hostService : hostedServiceListResponse.getHostedServices()) {
                if (AzureUtil.compareLocation(this.getRegion().getName(), hostService.getProperties().getLocation(), affinityGroupListResponse.getAffinityGroups())) {
                    for (DeploymentSlot slot : AzureUtil.getDeploymentSlots()) {
                        DeploymentGetResponse deploymentGetResponse = null;
                        try {
                            deploymentGetResponse = deploymentOperations.getBySlot(hostService.getServiceName(), slot);
                        }
                        catch (ServiceException e) {
                            if (e.getErrorCode().equals("ResourceNotFound")) continue;
                            logger.error((Object)("createInstanceBackup: (" + e.getErrorCode() + ") " + e.getMessage()));
                            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
                        }
                        for (Role role : deploymentGetResponse.getRoles()) {
                            if (!role.getRoleName().equals(instanceId)) continue;
                            targetRole = role;
                        }
                    }
                }
                if (targetRole == null) continue;
                break;
            }
            if (storageIds == null) {
                String key = "";
                Integer num = 0;
                for (DataVirtualHardDisk dvhd : targetRole.getDataVirtualHardDisks()) {
                    IResourceManagement.StorageBackup bkup_Data = this.createStorageBackup(dvhd.getName(), "", "", "");
                    String ssid = bkup_Data.getStorageBackupId().substring(bkup_Data.getStorageBackupId().lastIndexOf("_") + 1);
                    ssid = AzureUtil.getConvertSnapshotValue(ssid);
                    if (dvhd.getLogicalUnitNumber() != null) {
                        key = "LUN" + Integer.toString(dvhd.getLogicalUnitNumber());
                    } else {
                        key = "LUNNULL" + Integer.toString(num);
                        num = num + 1;
                    }
                    attachedDisks.put(key, dvhd.getMediaLink().toString() + "?snapshot=" + ssid);
                }
            }
            String storageAccountName = AzureUtil.getStorageAccountNameFromVHD(targetRole.getOSVirtualHardDisk().getMediaLink().toString());
            String containerName = AzureUtil.getContainerNameFromVHD(targetRole.getOSVirtualHardDisk().getMediaLink().toString());
            IResourceManagement.StorageBackup bkup_OS = this.createStorageBackup(targetRole.getOSVirtualHardDisk().getName(), "", "", "");
            String vhdFileName = AzureUtil.getVHDFileNameFromVHD(targetRole.getOSVirtualHardDisk().getMediaLink().toString());
            String snapshotID = AzureUtil.getConvertSnapshotValue(bkup_OS.getStorageBackupId().substring(bkup_OS.getStorageBackupId().lastIndexOf("_") + 1));
            String x_ms_copy_source = "/" + storageAccountName + "/" + containerName + "/" + vhdFileName + "?snapshot=" + snapshotID;
            request.setHeader("x-ms-copy-source", x_ms_copy_source);
            Configuration blobconfig = null;
            blobconfig = AzureUtil.getBlobConfiguration(storageAccountName, storageAccountOperations.getKeys(storageAccountName).getPrimaryKey());
            BlobContract blobContract = (BlobContract)((BlobContract)BlobService.create((Configuration)blobconfig).withRequestFilterLast((ServiceRequestFilter)request)).withResponseFilterLast((ServiceResponseFilter)response);
            CreateBlobOptions opt = new CreateBlobOptions();
            opt.setMetadata(attachedDisks);
            String backUpName = instanceId + "_BackUp_" + sdf.format(new Date()) + ".vhd";
            logger.info((Object)("BlobContract.createBlockBlob(" + containerName + "," + backUpName + ") " + " Metadata=" + opt.getMetadata() + "x-ms-copy-source=" + x_ms_copy_source));
            blobContract.createBlockBlob(containerName, backUpName, null, opt);
            String image_src = AzureUtil.getVHDUrl(storageAccountName, containerName, backUpName);
            VirtualMachineOSImageCreateParameters vmiParam = new VirtualMachineOSImageCreateParameters();
            vmiParam.setName(name);
            vmiParam.setDescription(description);
            vmiParam.setMediaLinkUri(new URI(image_src));
            vmiParam.setLabel(name);
            vmiParam.setOperatingSystemType(targetRole.getOSVirtualHardDisk().getOperatingSystem());
            logger.info((Object)("VirtualMachineOSImageOperations.create(" + name + "," + targetRole.getOSVirtualHardDisk().getOperatingSystem() + ")"));
            VirtualMachineOSImageCreateResponse operationResponse = virtualMachineOSImageOperations.create(vmiParam);
            logger.info((Object)("RequestId:" + operationResponse.getRequestId()));
            while ((operationStatusResponse = computeManagementClient.getOperationStatus(operationResponse.getRequestId())).getStatus().equals((Object)OperationStatus.InProgress)) {
            }
            logger.info((Object)("creating " + this.getClass().getSimpleName() + "..."));
            if (!operationStatusResponse.getStatus().equals((Object)OperationStatus.Succeeded)) {
                logger.error((Object)("failed in creating InstanceBackup " + operationStatusResponse.getError()));
                throw new CloudManagerFault(operationStatusResponse.getError().getMessage(), (Throwable)new Exception(operationStatusResponse.getError().getCode()));
            }
            logger.info((Object)("Successful in creating InstanceBackup " + this.getClass().getSimpleName() + "..."));
            request = new AzureUtil.AzureServiceRequestFilter();
            response = new AzureUtil.AzureServiceResponseFilter();
            request.changeURL(vhdFileName, vhdFileName + "?snapshot=" + snapshotID);
            BlobContract blobContract_del = (BlobContract)((BlobContract)BlobService.create((Configuration)blobconfig).withRequestFilterLast((ServiceRequestFilter)request)).withResponseFilterLast((ServiceResponseFilter)response);
            blobContract_del.deleteBlob(containerName, vhdFileName);
            instanceBackup.setInstanceId(instanceId);
            instanceBackup.setCreateTime(new Date());
            instanceBackup.setName(name);
            instanceBackup.setDescription(description);
            instanceBackup.setInstanceBackupId(name);
            if (targetRole.getOSVirtualHardDisk().getOperatingSystem().toLowerCase().equals("linux")) {
                instanceBackup.setPlatform(PlatformKind.linux);
            } else if (targetRole.getOSVirtualHardDisk().getOperatingSystem().toLowerCase().equals("windows")) {
                instanceBackup.setPlatform(PlatformKind.windows);
            } else {
                instanceBackup.setPlatform(PlatformKind.other);
            }
            instanceBackup.setResourceType("image");
        }
        catch (ServiceException e) {
            logger.error((Object)("createInstanceBackup: (" + e.getErrorCode() + ") " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("createInstanceBackup: " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
        }
        return instanceBackup;
    }
}

