/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.azure.factory;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.azure.factory.AzureAsyncOperations;
import com.microsoft.windowsazure.Configuration;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.compute.ComputeManagementClient;
import com.microsoft.windowsazure.management.compute.ComputeManagementService;
import com.microsoft.windowsazure.management.compute.VirtualMachineOSImageOperations;
import org.apache.log4j.Logger;

public class AzureDeleteInstanceBackup
extends AzureAsyncOperations {
    private Logger logger = Logger.getLogger(this.getClass());
    private String instanceBackupId = null;
    private Configuration config = null;

    public AzureDeleteInstanceBackup(Configuration config, String instanceBackupId) {
        this.config = config;
        this.instanceBackupId = instanceBackupId;
    }

    @Override
    public void execute() throws CloudManagerFault {
        block8: {
            try {
                OperationStatusResponse operationStatusResponse;
                this.logger.info((Object)("AzureDeleteInstanceBackup start: " + this.instanceBackupId));
                ComputeManagementClient computeManagementClient = ComputeManagementService.create((Configuration)this.config);
                VirtualMachineOSImageOperations virtualMachineOSImageOperations = computeManagementClient.getVirtualMachineOSImagesOperations();
                this.logger.info((Object)("VirtualMachineOSImageOperations.delete(" + this.instanceBackupId + ")"));
                OperationResponse operationResponse = virtualMachineOSImageOperations.delete(this.instanceBackupId, true);
                this.logger.info((Object)("RequestId:" + operationResponse.getRequestId()));
                while ((operationStatusResponse = computeManagementClient.getOperationStatus(operationResponse.getRequestId())).getStatus().equals((Object)OperationStatus.InProgress)) {
                }
                this.logger.info((Object)("deleting " + this.getClass().getSimpleName() + "..."));
                if (operationStatusResponse.getStatus().equals((Object)OperationStatus.Succeeded)) {
                    this.logger.info((Object)("successful in delete " + this.getClass().getSimpleName() + "..."));
                    break block8;
                }
                this.logger.error((Object)("failed in delete " + operationStatusResponse.getError()));
                this.putLog("DeleteInstanceBackup", "DeleteInstanceBackup was failed", operationStatusResponse.getError().getMessage());
                throw new CloudManagerFault(operationStatusResponse.getError().getMessage(), (Throwable)new Exception(operationStatusResponse.getError().getCode()));
            }
            catch (ServiceException e) {
                this.logger.error((Object)("AzureDeleteInstanceBackup: (" + e.getErrorCode() + ") " + e.getMessage()));
                this.putLog("DeleteInstanceBackup", "DeleteInstanceBackup was failed", e.getStackTrace().toString());
                throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
            }
            catch (Exception e) {
                this.logger.error((Object)("AzureDeleteInstanceBackup: " + e.getMessage()));
                this.putLog("DeleteInstanceBackup", "DeleteInstanceBackup was failed", e.getStackTrace().toString());
                throw new CloudManagerFault(e.getMessage(), (Throwable)e);
            }
            finally {
                this.logger.info((Object)("AzureDeleteInstanceBackup end: " + this.instanceBackupId));
            }
        }
    }
}

