/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.azure;

import com.clustercontrol.cloud.commons.PropValidator;
import com.clustercontrol.cloud.commons.PropertyContract;
import com.clustercontrol.commons.util.HinemosProperties;
import org.apache.log4j.Logger;

public enum AzureOptionPropertyConstants implements PropertyContract
{
    azure_os_win_pattern("hinemos.cloud.azure.os.win.pattern", "(.*windows.*)|(.*win.*)|(.*microsoft.*)"),
    azure_os_linux_pattern("hinemos.cloud.azure.os.linux.pattern", "(.*linux.*)|(.*cent\\s*os.*)|(.*ubuntu.*)"),
    azure_client_config_proxyDomain("hinemos.cloud.azure.client.config.proxyDomain", null),
    azure_client_config_proxyHost("hinemos.cloud.azure.client.config.proxyHost", null),
    azure_client_config_proxyPassword("hinemos.cloud.azure.client.config.proxyPassword", null),
    azure_client_config_proxyPort("hinemos.cloud.azure.client.config.proxyPort", String.valueOf(-1), PropValidator.intValidator),
    azure_client_config_proxyUsername("hinemos.cloud.azure.client.config.proxyUsername", null),
    azure_client_config_proxyWorkstation("hinemos.cloud.azure.client.config.proxyWorkstation", null),
    azure_client_config_connectionTimeout("hinemos.cloud.azure.client.config.connectionTimeout", String.valueOf(90000), PropValidator.intValidator),
    azure_client_config_readTimeout("hinemos.cloud.azure.client.config.readTimeout", String.valueOf(90000), PropValidator.intValidator),
    azure_client_config_userAgent("hinemos.cloud.azure.client.config.userAgent", ""),
    azure_base_uri("hinemos.cloud.azure.baseuri", "https://management.core.windows.net/"),
    azure_deployment_slots("hinemos.cloud.azure.deployment_slots", "production,staging"),
    azure_pfx_storepass("hinemos.cloud.azure.pfx.storepass", "changeit"),
    azure_pfx_storetype("hinemos.cloud.azure.pfx.storetype", "pkcs12"),
    azure_api_mode("hinemos.cloud.azure.api.mode", "async"),
    azure_async_delay_time("hinemos.cloud.azure.async.delayTime", String.valueOf(5), PropValidator.intValidator);

    public final String id;
    public final String value;
    public final PropValidator validator;

    private AzureOptionPropertyConstants(String id, String value) {
        this.id = id;
        this.value = value;
        this.validator = null;
    }

    private AzureOptionPropertyConstants(String id, String value, PropValidator validator) {
        this.id = id;
        this.value = value;
        this.validator = validator;
    }

    public String value() {
        String prop = HinemosProperties.getProperty((String)this.id, (String)this.value);
        if (this.validator != null) {
            try {
                this.validator.validate(prop);
            }
            catch (Exception e) {
                Logger logger = Logger.getLogger(AzureOptionPropertyConstants.class);
                logger.error((Object)(this.id + " is invalid(" + prop + "), using default value(" + this.value + ")."));
                prop = this.value;
            }
        }
        return prop;
    }

    public boolean match(String value) {
        return this.value().equals(value);
    }

    public String defaultValue() {
        return this.value;
    }
}

