/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.management.configuration;

import com.microsoft.windowsazure.Configuration;
import com.microsoft.windowsazure.core.utils.Base64;
import com.microsoft.windowsazure.core.utils.KeyStoreType;
import com.microsoft.windowsazure.management.configuration.ManagementConfiguration;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class PublishSettingsLoader {
    public static Configuration createManagementConfiguration(String publishSettingsFileName, String subscriptionId) throws IOException {
        if (publishSettingsFileName == null) {
            throw new IllegalArgumentException("The publish settings file cannot be null.");
        }
        if (subscriptionId == null) {
            throw new IllegalArgumentException("The subscription ID cannot be null.");
        }
        if (publishSettingsFileName.isEmpty()) {
            throw new IllegalArgumentException("The publish settings file cannot be empty.");
        }
        if (subscriptionId.isEmpty()) {
            throw new IllegalArgumentException("The subscription ID cannot be empty.");
        }
        File publishSettingsFile = new File(publishSettingsFileName);
        String outputKeyStore = System.getProperty("user.home") + File.separator + ".azure" + File.separator + subscriptionId + ".out";
        URI managementUrl = PublishSettingsLoader.createCertficateFromPublishSettingsFile(publishSettingsFile, subscriptionId, outputKeyStore);
        return ManagementConfiguration.configure(managementUrl, subscriptionId, outputKeyStore, "", KeyStoreType.pkcs12);
    }

    private static KeyStore createKeyStoreFromCertifcate(String certificate, String keyStoreFileName) throws IOException {
        KeyStore keyStore = null;
        try {
            keyStore = (double)Float.valueOf(System.getProperty("java.specification.version")).floatValue() < 1.7 ? PublishSettingsLoader.getBCProviderKeyStore() : KeyStore.getInstance("PKCS12");
            keyStore.load(null, "".toCharArray());
            ByteArrayInputStream sslInputStream = new ByteArrayInputStream(Base64.decode(certificate));
            keyStore.load(sslInputStream, "".toCharArray());
            File outStoreFile = new File(keyStoreFileName);
            if (!outStoreFile.getParentFile().exists()) {
                outStoreFile.getParentFile().mkdirs();
            }
            FileOutputStream outputStream = new FileOutputStream(keyStoreFileName);
            keyStore.store(outputStream, "".toCharArray());
            ((OutputStream)outputStream).close();
        }
        catch (KeyStoreException e) {
            throw new IllegalArgumentException("Cannot create keystore from the publish settings file", e);
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException("Cannot create keystore from the publish settings file", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Cannot create keystore from the publish settings file", e);
        }
        return keyStore;
    }

    private static URI createCertficateFromPublishSettingsFile(File publishSettingsFile, String subscriptionId, String outputKeyStore) throws IOException {
        URI managementUri;
        String certificate;
        block10: {
            certificate = null;
            managementUri = null;
            try {
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = documentBuilder.parse(publishSettingsFile);
                document.getDocumentElement().normalize();
                NodeList publishProfileNodeList = document.getElementsByTagName("PublishProfile");
                Element publishProfileElement = (Element)publishProfileNodeList.item(0);
                if (publishProfileElement.hasAttribute("SchemaVersion") && publishProfileElement.getAttribute("SchemaVersion").equals("2.0")) {
                    NodeList subscriptionNodeList = publishProfileElement.getElementsByTagName("Subscription");
                    for (int i = 0; i < subscriptionNodeList.getLength(); ++i) {
                        Element subscription = (Element)subscriptionNodeList.item(i);
                        String id = subscription.getAttribute("Id");
                        if (!id.equals(subscriptionId)) continue;
                        certificate = subscription.getAttribute("ManagementCertificate");
                        String serviceManagementUrl = subscription.getAttribute("ServiceManagementUrl");
                        try {
                            managementUri = new URI(serviceManagementUrl);
                            break block10;
                        }
                        catch (URISyntaxException e) {
                            throw new IllegalArgumentException("The syntax of the Url in the publish settings file is incorrect.", e);
                        }
                    }
                    break block10;
                }
                certificate = publishProfileElement.getAttribute("ManagementCertificate");
                String url = publishProfileElement.getAttribute("Url");
                try {
                    managementUri = new URI(url);
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("The syntax of the Url in the publish settings file is incorrect.", e);
                }
            }
            catch (ParserConfigurationException e) {
                throw new IllegalArgumentException("could not parse publishsettings file", e);
            }
            catch (SAXException e) {
                throw new IllegalArgumentException("could not parse publishsettings file", e);
            }
            catch (NullPointerException e) {
                throw new IllegalArgumentException("could not parse publishsettings file", e);
            }
        }
        PublishSettingsLoader.createKeyStoreFromCertifcate(certificate, outputKeyStore);
        return managementUri;
    }

    private static KeyStore getBCProviderKeyStore() {
        KeyStore keyStore = null;
        try {
            Class<?> providerClass = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
            Security.addProvider((Provider)providerClass.newInstance());
            Field field = providerClass.getField("PROVIDER_NAME");
            keyStore = KeyStore.getInstance("PKCS12", field.get(null).toString());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create keystore from publishsettings file.Make sure java versions less than 1.7 has bouncycastle jar in classpath", e);
        }
        return keyStore;
    }
}

