/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.exception;

import com.microsoft.windowsazure.core.utils.BOMInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ServiceException
extends Exception {
    private static final long serialVersionUID = -4942076377009150131L;
    private int httpStatusCode;
    private String httpReasonPhrase;
    private String serviceName;
    private String errorCode;
    private String errorMessage;
    private Map<String, String> errorValues;
    private String rawResponseBody;

    public ServiceException() {
        this.init();
    }

    public ServiceException(String message) {
        super(message);
        this.init();
    }

    public ServiceException(String message, Throwable cause) {
        super(message, cause);
        this.init();
    }

    public ServiceException(Throwable cause) {
        super(cause);
        this.init();
    }

    private void init() {
        this.errorValues = new HashMap<String, String>();
    }

    @Override
    public String getMessage() {
        StringBuffer buffer = new StringBuffer(50);
        buffer.append(super.getMessage());
        if (this.rawResponseBody != null) {
            buffer.append("\nResponse Body: ");
            buffer.append(this.rawResponseBody);
        }
        return buffer.toString();
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public void setHttpStatusCode(int httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    public String getHttpReasonPhrase() {
        return this.httpReasonPhrase;
    }

    public void setHttpReasonPhrase(String httpReasonPhrase) {
        this.httpReasonPhrase = httpReasonPhrase;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Map<String, String> getErrorValues() {
        return this.errorValues;
    }

    public void setErrorValues(Map<String, String> errorValues) {
        this.errorValues = errorValues;
    }

    public String getErrorValue(String name) {
        return this.errorValues.get(name);
    }

    public void setErrorValue(String name, String value) {
        this.errorValues.put(name, value);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setRawResponseBody(String body) {
        this.rawResponseBody = body;
    }

    public String getRawResponseBody() {
        return this.rawResponseBody;
    }

    public static ServiceException create(HttpRequest httpRequest, String requestContent, HttpResponse httpResponse, HttpEntity entity, String defaultTo) {
        ServiceException serviceException = httpResponse.getEntity().getContentType().getValue().equals("application/json") || httpResponse.getEntity().getContentType().getValue().equals("text/json") ? ServiceException.createFromJson(httpRequest, requestContent, httpResponse, entity) : (httpResponse.getEntity().getContentType().getValue().equals("application/xml") || httpResponse.getEntity().getContentType().getValue().equals("text/xml") ? ServiceException.createFromXml(httpRequest, requestContent, httpResponse, entity) : ("Json".equals(defaultTo) ? ServiceException.createFromJson(httpRequest, requestContent, httpResponse, entity) : ServiceException.createFromXml(httpRequest, requestContent, httpResponse, entity)));
        return serviceException;
    }

    public static ServiceException createFromXml(HttpRequest httpRequest, String requestContent, HttpResponse httpResponse, HttpEntity entity) {
        ServiceException serviceException;
        String content;
        try {
            content = EntityUtils.toString((HttpEntity)entity);
        }
        catch (IOException e) {
            return new ServiceException(e);
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse(new BOMInputStream(new ByteArrayInputStream(content.getBytes())));
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            String code = xpath.compile("/Error/Code/text()").evaluate(responseDoc);
            String message = xpath.compile("/Error/Message/text()").evaluate(responseDoc);
            serviceException = new ServiceException(ServiceException.buildExceptionMessage(code, message, content, httpResponse));
            serviceException.setErrorCode(code);
            serviceException.setErrorMessage(message);
        }
        catch (XPathExpressionException e) {
            return new ServiceException(content);
        }
        catch (ParserConfigurationException e) {
            return new ServiceException(content);
        }
        catch (SAXException e) {
            return new ServiceException(content);
        }
        catch (IOException e) {
            return new ServiceException(content);
        }
        serviceException.setHttpStatusCode(httpResponse.getStatusLine().getStatusCode());
        serviceException.setHttpReasonPhrase(httpResponse.getStatusLine().getReasonPhrase());
        return serviceException;
    }

    private static String buildExceptionMessage(String code, String message, String responseContent, HttpResponse httpResponse) {
        return code != null && message != null ? code + ": " + message : (message != null ? message : (code != null ? code : (responseContent != null ? responseContent : (httpResponse != null && httpResponse.getStatusLine() != null && httpResponse.getStatusLine().getReasonPhrase() != null ? httpResponse.getStatusLine().getReasonPhrase() : (httpResponse != null && httpResponse.getStatusLine() != null ? Integer.toString(httpResponse.getStatusLine().getStatusCode()) : "Invalid operation")))));
    }

    public static ServiceException createFromJson(HttpRequest httpRequest, String requestContent, HttpResponse httpResponse, HttpEntity entity) {
        ServiceException serviceException;
        String content;
        try {
            content = EntityUtils.toString((HttpEntity)entity);
        }
        catch (IOException e) {
            return new ServiceException(e);
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode responseDoc = objectMapper.readTree(content);
            String code = responseDoc.get("Code") != null ? responseDoc.get("Code").getTextValue() : (responseDoc.get("code") != null ? responseDoc.get("code").getTextValue() : Integer.toString(httpResponse.getStatusLine().getStatusCode()));
            String message = responseDoc.get("Message") != null ? responseDoc.get("Message").getTextValue() : (responseDoc.get("message") != null ? responseDoc.get("message").getTextValue() : httpResponse.getStatusLine().getReasonPhrase());
            serviceException = new ServiceException(ServiceException.buildExceptionMessage(code, message, content, httpResponse));
            serviceException.setErrorCode(code);
            serviceException.setErrorMessage(message);
        }
        catch (IOException e) {
            return new ServiceException();
        }
        serviceException.setHttpStatusCode(httpResponse.getStatusLine().getStatusCode());
        serviceException.setHttpReasonPhrase(httpResponse.getStatusLine().getReasonPhrase());
        return serviceException;
    }
}

