/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public class Env {
    private final String bundleName;
    private final Properties properties;

    public Env() {
        this(null, System.getProperties());
    }

    public Env(String bundleName) {
        this(bundleName, System.getProperties());
    }

    public Env(Properties properties) {
        this(null, properties);
    }

    public Env(String bundleName, Properties properties) {
        this.bundleName = bundleName;
        this.properties = properties;
    }

    public String get(String key) {
        String value = System.getenv(Env.asEnvKey(key));
        if (value == null && (value = this.properties.getProperty(key)) == null && this.bundleName != null) {
            try {
                value = ResourceBundle.getBundle(this.bundleName).getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return value;
    }

    private static String asEnvKey(String key) {
        return key.replace('.', '_').toUpperCase();
    }
}

