/*
 * Decompiled with CFR 0.152.
 */
package cucumber.api;

import cucumber.runtime.ParameterInfo;
import cucumber.runtime.table.DiffableRow;
import cucumber.runtime.table.TableConverter;
import cucumber.runtime.table.TableDiffException;
import cucumber.runtime.table.TableDiffer;
import cucumber.runtime.table.TypeReference;
import cucumber.runtime.xstream.LocalizedXStreams;
import gherkin.formatter.PrettyFormatter;
import gherkin.formatter.model.DataTableRow;
import gherkin.formatter.model.Row;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DataTable {
    private final List<List<String>> raw;
    private final List<DataTableRow> gherkinRows;
    private final TableConverter tableConverter;

    public static DataTable create(List<?> raw) {
        return DataTable.create(raw, Locale.getDefault(), null, new String[0]);
    }

    public static DataTable create(List<?> raw, String format, String ... columnNames) {
        return DataTable.create(raw, Locale.getDefault(), format, columnNames);
    }

    public static DataTable create(List<?> raw, Locale locale, String ... columnNames) {
        return DataTable.create(raw, locale, null, columnNames);
    }

    private static DataTable create(List<?> raw, Locale locale, String format, String ... columnNames) {
        ParameterInfo parameterInfo = new ParameterInfo(null, format, null, null);
        TableConverter tableConverter = new TableConverter(new LocalizedXStreams(Thread.currentThread().getContextClassLoader()).get(locale), parameterInfo);
        return tableConverter.toTable(raw, columnNames);
    }

    public DataTable(List<DataTableRow> gherkinRows, TableConverter tableConverter) {
        this.gherkinRows = gherkinRows;
        this.tableConverter = tableConverter;
        ArrayList raw = new ArrayList();
        for (DataTableRow row : gherkinRows) {
            ArrayList list = new ArrayList();
            list.addAll(row.getCells());
            raw.add(Collections.unmodifiableList(list));
        }
        this.raw = Collections.unmodifiableList(raw);
    }

    public List<List<String>> raw() {
        return this.raw;
    }

    public <T> T convert(Type type) {
        return this.tableConverter.convert(type, this);
    }

    public List<Map<String, String>> asMaps() {
        return this.asList(new TypeReference<Map<String, String>>(){}.getType());
    }

    public <T> List<T> asList(Type type) {
        List result = this.tableConverter.toList(type, this);
        return result;
    }

    public List<String> topCells() {
        return this.raw.get(0);
    }

    public List<List<String>> cells(int firstRow) {
        return this.raw.subList(firstRow, this.raw.size());
    }

    public DataTable toTable(List<?> raw, String ... columnNames) {
        return this.tableConverter.toTable(raw, columnNames);
    }

    public void diff(List<?> other) throws TableDiffException {
        List<String> topCells = this.topCells();
        DataTable otherTable = this.toTable(other, topCells.toArray(new String[topCells.size()]));
        this.diff(otherTable);
    }

    public void diff(DataTable other) throws TableDiffException {
        new TableDiffer(this, other).calculateDiffs();
    }

    public List<DataTableRow> getGherkinRows() {
        return Collections.unmodifiableList(this.gherkinRows);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        PrettyFormatter pf = new PrettyFormatter((Appendable)result, true, false);
        pf.table(this.getGherkinRows());
        pf.eof();
        return result.toString();
    }

    public List<DiffableRow> diffableRows() {
        ArrayList<DiffableRow> result = new ArrayList<DiffableRow>();
        List<List<String>> convertedRows = this.raw();
        for (int i = 0; i < convertedRows.size(); ++i) {
            result.add(new DiffableRow((Row)this.getGherkinRows().get(i), convertedRows.get(i)));
        }
        return result;
    }

    public TableConverter getTableConverter() {
        return this.tableConverter;
    }

    public List<String> flatten() {
        ArrayList<String> result = new ArrayList<String>();
        for (List<String> rows : this.raw()) {
            for (String cell : rows) {
                result.add(cell);
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataTable)) {
            return false;
        }
        DataTable dataTable = (DataTable)o;
        return ((Object)this.raw).equals(dataTable.raw);
    }

    public int hashCode() {
        return ((Object)this.raw).hashCode();
    }
}

