/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.util;

import com.clustercontrol.accesscontrol.session.AccessControllerBean;
import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.IMessagesHolder;
import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.bean.CloudRegion;
import com.clustercontrol.cloud.factory.AddedEventNotifier;
import com.clustercontrol.cloud.factory.ICloudServiceOperator;
import com.clustercontrol.cloud.registry.IObjectChangedService;
import com.clustercontrol.cloud.registry.ObjectRegistryService;
import com.clustercontrol.cloud.util.CloudMessageUtil;
import com.clustercontrol.cloud.util.HinemosUtil;
import com.clustercontrol.cloud.util.JobControllerBeanWrapper;
import com.clustercontrol.cloud.util.RepositoryControllerBeanWrapper;
import com.clustercontrol.fault.FacilityDuplicate;
import com.clustercontrol.fault.FacilityNotFound;
import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.InvalidObjectPrivilege;
import com.clustercontrol.fault.InvalidRole;
import com.clustercontrol.fault.InvalidSetting;
import com.clustercontrol.fault.JobInvalid;
import com.clustercontrol.fault.JobMasterNotFound;
import com.clustercontrol.fault.NotifyNotFound;
import com.clustercontrol.fault.PrivilegeDuplicate;
import com.clustercontrol.fault.UsedObjectPrivilege;
import com.clustercontrol.fault.UserNotFound;
import com.clustercontrol.jobmanagement.bean.JobInfo;
import com.clustercontrol.jobmanagement.bean.JobParameterInfo;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.bean.SystemParameterConstant;
import com.clustercontrol.jobmanagement.session.JobControllerBean;
import com.clustercontrol.repository.bean.NodeInfo;
import com.clustercontrol.repository.bean.NodeVariableInfo;
import com.clustercontrol.repository.bean.ScopeInfo;
import com.clustercontrol.repository.session.RepositoryControllerBean;
import java.util.ArrayList;
import java.util.Locale;

public class AccountResourceUtil {
    public static final String cloudRootScopeId = "Cloud";
    public static final String cloudRootScopeNameId = "cloudRootScopeName";
    public static final String cloudAccountResourceListId = "CloudAccountResourceList";
    public static final String cloudAccountResourceListNameId = "cloudAccountResourceListName";
    public static final String templateJobnetId = "Template";
    public static final String templateJobnetNameId = "TemplateJobnetName";
    public static final String autoControlJobnetId = "AutoControl";
    public static final String autoControlJobnetNameId = "AutoControlJobnetName";
    private static final String group_postfix = "_Group";
    private static final String scope_postfix = "_Scope";

    private static void createCloudScopeIfNotExist(RepositoryControllerBean repositoryBean, IMessagesHolder messages) throws HinemosUnknown, InvalidRole, FacilityDuplicate, InvalidSetting, CloudManagerFault {
        try {
            repositoryBean.getScope(cloudRootScopeId);
        }
        catch (FacilityNotFound e1) {
            ScopeInfo scopeInfo = HinemosUtil.createScope((String)cloudRootScopeId, (String)messages.getString(cloudRootScopeNameId), (String)"ADMINISTRATORS");
            try (AddedEventNotifier<ScopeInfo> notifier = new AddedEventNotifier<ScopeInfo>("Node_Cloud_Add", ScopeInfo.class, scopeInfo);){
                repositoryBean.addScope(null, scopeInfo);
                notifier.setCompleted();
            }
        }
    }

    private static void createAccountResourceScopeIfNotExist(RepositoryControllerBean repositoryBean, AccountResourceIdHelper idHelper, String accountResourceName, String roleId) throws HinemosUnknown, InvalidRole, FacilityDuplicate, InvalidSetting, CloudManagerFault {
        try {
            repositoryBean.getScope(idHelper.getScopeId());
        }
        catch (FacilityNotFound e1) {
            ScopeInfo scopeInfo = HinemosUtil.createScope((String)idHelper.getScopeId(), (String)accountResourceName, (String)roleId);
            try (AddedEventNotifier<ScopeInfo> notifier = new AddedEventNotifier<ScopeInfo>("Node_CloudAccountResourceScope_Add", ScopeInfo.class, scopeInfo);){
                repositoryBean.addScope(cloudRootScopeId, scopeInfo);
                notifier.setCompleted();
            }
        }
    }

    public static void attachScope(RepositoryControllerBean repositoryBean, String accountResourceId, String accountResourceName, String region, String regionName, String zone, String facilityId, String roleId, IMessagesHolder messages) throws InvalidSetting, InvalidRole, HinemosUnknown, FacilityDuplicate, CloudManagerFault {
        AccountResourceIdHelper idHelper = new AccountResourceIdHelper(accountResourceId);
        try {
            repositoryBean.assignNodeScope(idHelper.decorateZone(zone), new String[]{facilityId});
        }
        catch (InvalidSetting e) {
            ScopeInfo scopeInfo;
            AccountResourceUtil.createCloudScopeIfNotExist(repositoryBean, messages);
            AccountResourceUtil.createAccountResourceScopeIfNotExist(repositoryBean, idHelper, accountResourceName, roleId);
            try {
                repositoryBean.getScope(idHelper.decorateRegion(region));
            }
            catch (FacilityNotFound e1) {
                scopeInfo = HinemosUtil.createScope((String)idHelper.decorateRegion(region), (String)regionName, (String)roleId);
                repositoryBean.addScope(idHelper.getScopeId(), scopeInfo);
            }
            try {
                repositoryBean.getScope(idHelper.decorateZone(zone));
            }
            catch (FacilityNotFound e1) {
                scopeInfo = HinemosUtil.createScope((String)idHelper.decorateZone(zone), (String)zone, (String)roleId);
                repositoryBean.addScope(idHelper.decorateRegion(region), scopeInfo);
            }
            repositoryBean.assignNodeScope(idHelper.decorateZone(zone), new String[]{facilityId});
        }
    }

    public static void buildAccountResourceHierarchy(RepositoryControllerBean repositry, String accountResourceId, String accountResourceName, String cloudId, String description, String cloudServiceId, String ownerId, IMessagesHolder messages) throws InvalidRole, CloudManagerFault {
        NodeInfo nodeInfo = AccountResourceUtil.createAccountResourceNode(accountResourceId, accountResourceName, cloudId, description, cloudServiceId, ownerId);
        try {
            ((IObjectChangedService)ObjectRegistryService.registry().get(IObjectChangedService.class)).firePreAddedEvent("Node_AccountResource", NodeInfo.class, (Object)nodeInfo);
        }
        catch (CloudManagerFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalManagerError(e.getMessage(), (Throwable)e);
        }
        AccountResourceIdHelper idHelper = new AccountResourceIdHelper(accountResourceId);
        try {
            AccountResourceUtil.registAccountResourceNode(repositry, idHelper, nodeInfo, messages);
            AccountResourceUtil.registAccountResourceHierarchy(repositry, idHelper, accountResourceName, cloudServiceId, ownerId, messages);
            AccountResourceUtil.registAccountResourceJobUnit((JobControllerBean)JobControllerBeanWrapper.bean(), idHelper, accountResourceName, description, ownerId, messages);
        }
        catch (FacilityDuplicate | HinemosUnknown | InvalidObjectPrivilege | InvalidSetting | JobInvalid | JobMasterNotFound | NotifyNotFound | UserNotFound e) {
            throw ErrorCode.HINEMOS_MANAGER_ERROR.cloudManagerFault((Exception)e);
        }
        try {
            ((IObjectChangedService)ObjectRegistryService.registry().get(IObjectChangedService.class)).firePostAddedEvent("Node_AccountResource", NodeInfo.class, (Object)nodeInfo);
        }
        catch (CloudManagerFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalManagerError(e.getMessage(), (Throwable)e);
        }
    }

    public static void removeAccountResourceHierarchy(RepositoryControllerBean repositry, String accountResourceId) throws CloudManagerFault {
        AccountResourceIdHelper idHelper = new AccountResourceIdHelper(accountResourceId);
        try {
            RepositoryControllerBeanWrapper.bean().deleteNode(accountResourceId);
        }
        catch (Exception e) {
            CloudMessageUtil.notify_Not_Delete_AccountResource_Not_To_Delete_Facility(accountResourceId, accountResourceId, e);
        }
        try {
            RepositoryControllerBeanWrapper.bean().deleteScope(idHelper.getGroupId());
        }
        catch (Exception e) {
            CloudMessageUtil.notify_Not_Delete_AccountResource_Not_To_Delete_Facility(accountResourceId, idHelper.getGroupId(), e);
        }
        try {
            RepositoryControllerBeanWrapper.bean().deleteScope(idHelper.getScopeId());
        }
        catch (Exception e) {
            CloudMessageUtil.notify_Not_Delete_AccountResource_Not_To_Delete_Facility(accountResourceId, idHelper.getScopeId(), e);
        }
        try {
            JobControllerBeanWrapper.bean().deleteJobunit(idHelper.getJobUnitId());
        }
        catch (Exception e) {
            CloudMessageUtil.notify_Not_Delete_AccountResource_Not_To_Delete_JobUnit(accountResourceId, idHelper.getJobUnitId(), e);
        }
    }

    public static NodeInfo createAccountResourceNode(String accountResourceId, String accountResourceName, String cloudTypeId, String description, String cloudServiceId, String roleId) {
        return HinemosUtil.createNodeInfo((String)accountResourceId, (String)accountResourceName, (String)cloudTypeId, (String)cloudTypeId, (String)accountResourceName, (String)description, (String)"AccountResource", (String)cloudServiceId, (String)accountResourceId, null, null, null, null, (String)roleId, (NodeVariableInfo[])new NodeVariableInfo[0]);
    }

    public static void registAccountResourceNode(RepositoryControllerBean repositoryBean, AccountResourceIdHelper idUtil, NodeInfo nodeInfo, IMessagesHolder messages) throws InvalidSetting, InvalidRole, HinemosUnknown, FacilityDuplicate, CloudManagerFault {
        repositoryBean.addNode(nodeInfo);
        try {
            repositoryBean.assignNodeScope(idUtil.getGroupId(), new String[]{nodeInfo.getFacilityId()});
        }
        catch (InvalidSetting e) {
            ScopeInfo scopeInfo;
            AccountResourceUtil.createCloudScopeIfNotExist(repositoryBean, messages);
            try {
                repositoryBean.getScope(cloudAccountResourceListId);
            }
            catch (FacilityNotFound e1) {
                scopeInfo = HinemosUtil.createScope((String)cloudAccountResourceListId, (String)messages.getString(cloudAccountResourceListNameId), (String)"ADMINISTRATORS");
                repositoryBean.addScope(cloudRootScopeId, scopeInfo);
            }
            try {
                repositoryBean.getScope(idUtil.getGroupId());
            }
            catch (FacilityNotFound e1) {
                scopeInfo = HinemosUtil.createScope((String)idUtil.getGroupId(), (String)nodeInfo.getFacilityName(), (String)nodeInfo.getOwnerRoleId());
                repositoryBean.addScope(cloudAccountResourceListId, scopeInfo);
            }
            repositoryBean.assignNodeScope(idUtil.getGroupId(), new String[]{nodeInfo.getFacilityId()});
        }
    }

    public static void registAccountResourceHierarchy(RepositoryControllerBean repositoryBean, AccountResourceIdHelper idUtil, String accountResourceName, String serviceId, String roleId, IMessagesHolder messages) throws FacilityDuplicate, InvalidSetting, InvalidRole, HinemosUnknown, FacilityDuplicate, CloudManagerFault {
        AccountResourceUtil.createCloudScopeIfNotExist(repositoryBean, messages);
        AccountResourceUtil.createAccountResourceScopeIfNotExist(repositoryBean, idUtil, accountResourceName, roleId);
        ICloudServiceOperator operator = (ICloudServiceOperator)ObjectRegistryService.registry().get(ICloudServiceOperator.class);
        for (CloudRegion r : operator.findCloudRegionsByService(serviceId)) {
            try {
                repositoryBean.getScope(idUtil.decorateRegion(r.getRegion()));
            }
            catch (FacilityNotFound | InvalidRole e1) {
                ScopeInfo scopeInfo = HinemosUtil.createScope((String)idUtil.decorateRegion(r.getRegion()), (String)r.getRegionName(), (String)roleId);
                repositoryBean.addScope(idUtil.getScopeId(), scopeInfo);
            }
        }
    }

    public static void registAccountResourceJobUnit(JobControllerBean jobBean, AccountResourceIdHelper idUtil, String accountResourceName, String description, String roleId, IMessagesHolder messages) throws CloudManagerFault, NotifyNotFound, HinemosUnknown, JobMasterNotFound, UserNotFound, InvalidRole, JobInvalid, InvalidObjectPrivilege {
        JobTreeItem root = jobBean.getJobTree(roleId, true, Locale.getDefault());
        JobTreeItem item = HinemosUtil.searchJobTreeItem((JobTreeItem)root, (String)idUtil.getJobUnitId(), (String)idUtil.getJobUnitId());
        if (item != null) {
            throw ErrorCode.ACCOUNTRESOURCE_JOBUNIT_ALREADY_EXIST.cloudManagerFault(idUtil.getJobUnitId());
        }
        JobInfo info = HinemosUtil.createJobInfo((String)idUtil.getJobUnitId(), (int)0, (String)accountResourceName, (String)description, (String)roleId);
        info.setJobunitId(idUtil.getJobUnitId());
        ArrayList<JobParameterInfo> params = new ArrayList<JobParameterInfo>();
        for (ArrayList paramData : SystemParameterConstant.ALL) {
            JobParameterInfo param = new JobParameterInfo();
            param.setParamId((String)paramData.get(0));
            param.setType(Integer.valueOf(0));
            param.setValue("auto");
            param.setDescription((String)paramData.get(1));
            params.add(param);
        }
        info.setParam(params);
        JobTreeItem accountResourceUnit = new JobTreeItem();
        accountResourceUnit.setData(info);
        root.addChildren(accountResourceUnit);
        accountResourceUnit.setParent(root);
        HinemosUtil.relateJobTreeItems((JobTreeItem)accountResourceUnit, (JobTreeItem)HinemosUtil.createJobnet((String)templateJobnetId, (String)messages.getString(templateJobnetNameId), (String)"", (String)roleId));
        HinemosUtil.relateJobTreeItems((JobTreeItem)accountResourceUnit, (JobTreeItem)HinemosUtil.createJobnet((String)autoControlJobnetId, (String)messages.getString(autoControlJobnetNameId), (String)"", (String)roleId));
        jobBean.registerJobunit(accountResourceUnit);
    }

    public static void addAccountResourceRightToRole(AccessControllerBean accessBean, String roleId, String accountResourceId) throws PrivilegeDuplicate, UsedObjectPrivilege, HinemosUnknown, InvalidSetting, InvalidRole, JobMasterNotFound {
        AccountResourceIdHelper idHelper = new AccountResourceIdHelper(accountResourceId);
        HinemosUtil.addFullRightToObject((AccessControllerBean)accessBean, (String)roleId, (String)"PLT_REP", (String)idHelper.getScopeId());
        HinemosUtil.addFullRightToObject((AccessControllerBean)accessBean, (String)roleId, (String)"PLT_REP", (String)idHelper.getGroupId());
        HinemosUtil.addFullRightToObject((AccessControllerBean)accessBean, (String)roleId, (String)"JOB", (String)idHelper.getJobUnitId());
    }

    public static void removeAccountResourceRightToRole(AccessControllerBean accessBean, String roleId, String accountResourceId) throws PrivilegeDuplicate, UsedObjectPrivilege, HinemosUnknown, InvalidSetting, InvalidRole, JobMasterNotFound {
        AccountResourceIdHelper idHelper = new AccountResourceIdHelper(accountResourceId);
        HinemosUtil.removeFullRightFromObject((AccessControllerBean)accessBean, (String)roleId, (String)"PLT_REP", (String)idHelper.getScopeId());
        HinemosUtil.removeFullRightFromObject((AccessControllerBean)accessBean, (String)roleId, (String)"PLT_REP", (String)idHelper.getGroupId());
        HinemosUtil.removeFullRightFromObject((AccessControllerBean)accessBean, (String)roleId, (String)"JOB", (String)idHelper.getJobUnitId());
    }

    public static String createAccountResourceGroupId(String accountResourceId) {
        return accountResourceId + group_postfix;
    }

    public static String createAccountResourceScopeId(String accountResourceId) {
        return accountResourceId + scope_postfix;
    }

    public static String createAccountResourceJobUnitId(String accountResourceId) {
        return accountResourceId;
    }

    public static String createAccountResourceZoneId(String accountResourceId, String zone) {
        return accountResourceId + "_" + zone;
    }

    public static String createAccountResourceRegionId(String accountResourceId, String region) {
        return accountResourceId + "_" + region;
    }

    public static class AccountResourceIdHelper {
        private String accountResourceId;
        private String accountResourceScopeId;
        private String accountResourceGroupId;

        public AccountResourceIdHelper(String accountResourceId) {
            assert (accountResourceId != null);
            this.accountResourceId = accountResourceId;
        }

        public String getAccountResourceId() {
            return this.accountResourceId;
        }

        public String getGroupId() {
            if (this.accountResourceGroupId == null) {
                this.accountResourceGroupId = AccountResourceUtil.createAccountResourceGroupId(this.accountResourceId);
            }
            return this.accountResourceGroupId;
        }

        public String getScopeId() {
            if (this.accountResourceScopeId == null) {
                this.accountResourceScopeId = AccountResourceUtil.createAccountResourceScopeId(this.accountResourceId);
            }
            return this.accountResourceScopeId;
        }

        public String getJobUnitId() {
            return this.accountResourceId;
        }

        public String decorateZone(String zoneId) {
            return AccountResourceUtil.createAccountResourceZoneId(this.accountResourceId, zoneId);
        }

        public String decorateRegion(String regionId) {
            return AccountResourceUtil.createAccountResourceRegionId(this.accountResourceId, regionId);
        }
    }
}

